import { requestPOST, requestGET } from "@/utils/request.js";

export default {
  // 获取五粮液商品推荐数据
  getWlyList(data) {
    return requestGET(`${process.env.BASE_URL}/innerApi/wlyService/commodityExtend/restaurant/recommended`, data);
  },
  // 获取搜索热门词
  getHotWordsApi(data) {
    return requestPOST(`${process.env.OLSHOP_URL}/product/query_popular_words_shop`, data);
  },
  queryProductInfo(data) {
    return requestPOST(`${process.env.OLSHOP_URL}/product/query_product_info`, data);
  },
  // 扫码查询商品
  selectProductInfoOnEs(data) {
    return requestPOST(`${process.env.OLSHOP_URL}/product/select_product_info_on_es`, data);
  },
  queryBriefProductInfo(data) {
    return requestPOST(`${process.env.OLSHOP_URL}/product/query_brief_product_info`, data);
  },
  queryMoreProductInfo(data) {
    return requestPOST(`${process.env.OLSHOP_URL}/product/query_more_product_info`, data);
  },
  //POST  查询规格名及对应的规格值信息
  query_specification_name_and_values_list(data) {
    return requestPOST(`${process.env.OLSHOP_URL}/product/query_specification_name_and_values_list`, data)
  },
  //查询商品品牌
  queryProductBrand(data) {
    return requestPOST(`${process.env.OLSHOP_URL}/product/query_brand_by_page`, data)
  },
  //查询商品品牌
  getProductTopCategory(data) {
    return requestPOST(`${process.env.OLSHOP_URL}/product/get_product_top_category`, data)
  },
  //查询商品属性
  query_product_attribute_values_list(data) {
    return requestPOST(`${process.env.OLSHOP_URL}/product/query_product_attribute_values_list`, data)
  },
   // 已加购
   query_goods_cart_info(data) {
    return requestPOST(`${process.env.OLSHOP_URL}/cart/query_goods_cart_info`, data)
  },
   // 已收藏
   batch_query_collect_count(data) {
    return requestPOST(`${process.env.OLSHOP_URL}/product/batch_query_collect_count`, data)
  },
   // 收藏
   collect_goods(data) {
    return requestPOST(`${process.env.OLSHOP_URL}/product/collect_goods?productId=${data.productId}&terminalProductId=${data.terminalProductId}`)
  },
   // 取消收藏
   uncollect_goods(data) {
    return requestPOST(`${process.env.OLSHOP_URL}/product/uncollect_goods?productId=${data.productId}&terminalProductId=${data.terminalProductId}`, data)
  },
  // 根据 productId 查询商品信息
  queryProductInformation(productId) {
    return requestGET(`${process.env.OLSHOP_URL}/product/queryProductInformation?productId=${productId}`)
  },
};
