import {requestPOST,requestGET} from "@/utils/request.js";

export default {
    //获取直播间列表
    queryLiveList(){
        return requestGET(`${process.env.OLSHOP_URL}/liveBroadcastInfo/getList`)
    },
    //获取直播间详情
    queryLiveDetail(options){
        return requestGET(`${process.env.OLSHOP_URL}/liveBroadcastInfo/queryDetail`,options)
    },
    //更新直播状态
    updateLiveStatus(options){
        return requestPOST(`${process.env.OLSHOP_URL}/liveBroadcastInfo/updateStateByLiveId`,options)
    },
    //获取直播评论
    queryLiveComments(options){
        return requestPOST(`${process.env.OLSHOP_URL}/liveBroadcastInfo/getLiveStateById`,options)
    },
    //获取商品列表接口
    queryProductList(options){
        return requestGET(`${process.env.OLSHOP_URL}/liveBroadcastGoods/getListByLiveBroadcastId`,options)
    },
    //直播商品上下屏
    queryProductUpDown(options){
        return requestPOST(`${process.env.OLSHOP_URL}/liveBroadcastGoods/updateUpperScreenByGoodsIdAndLiveId`,options)
    },
    //获取已完成的直播
    queryCompleteLive(options){
        return requestPOST(`${process.env.OLSHOP_URL}/liveBroadcastInfo/historyRecord`,options)
    },
    //完成的直播详情
    queryCompleteDetail(options){
        return requestGET(`${process.env.OLSHOP_URL}/liveBroadcastInfo/getLiveStatisticsById`,options)
    },
    //获取服务器时间戳
    queryServerTimeNow(){
        return requestGET(`${process.env.OLSHOP_URL}/liveBroadcastInfo/getServerTimeNow`)
    },
    // 根据号码查询主播创建直播权限状态
    queryLivePermissions(options){
        return requestPOST(`${process.env.OLSHOP_URL}/liveAnchor/getAuthorityByPhone`,options)
    },
    //申请直播权限
    applyAuthority(options){
        return requestPOST(`${process.env.OLSHOP_URL}/liveAnchor/applyAuthority`,options)
    },
    // 添加申请主播结果通知订阅消息
    addLiveResultMsg(options){
        return requestPOST(`${process.env.OLSHOP_URL}/broadcastReminderRecord/addLiveAnchorByCustomer`,options)
    }
 }