import compass from "mayi-front-tools/compass"

const TRACK_NAME = 'compass'

function trackSetOpenid(openid) {
  compass.setOpenid(openid);
}

function trackEvent(eventName, payload) {
  compass.track(eventName, payload);
}

function trackLogin(phoneNumber) {
  compass.login(phoneNumber)
}

export default {
  init(mpApp) {
    if (!['xhyx_uat', 'xhyx_prod'].includes(process.env.NODE_ENV)) return;
    if (!mpApp[TRACK_NAME]) {
      // 配置初始化参数
      compass.init({
        name: 'compass',
        server_url: 'https://track.hebeijiaoyu.cn/api/trackminimessage?productId=xinhuayouxuan',
        // 全埋点控制开关
        autoTrack:{
          appLaunch: true, // 默认为 true，false 则关闭 $MPLaunch 事件采集
          appShow: true, // 默认为 true，false 则关闭 $MPShow 事件采集
          appHide: true, // 默认为 true，false 则关闭 $MPHide 事件采集
          pageShow: true, // 默认为 true，false 则关闭 $MPViewScreen 事件采集
          pageShare: true, // 默认为 true，false 则关闭 $MPShare 事件采集
          mpClick: false, // 默认为 false，true 则开启 $MPClick 事件采集
          mpFavorite: true, // 默认为 true，false 则关闭 $MPAddFavorites 事件采集
          pageLeave: false // 默认为 false， true 则开启 $MPPageLeave事件采集
        },
        // 是否允许控制台打印查看埋点数据(建议开启查看)
        show_log: true
      });
      mpApp[TRACK_NAME] = compass;
      mpApp.trackSetOpenid = trackSetOpenid;
      mpApp.trackEvent = trackEvent;
      mpApp.trackLogin = trackLogin;
    }
  }
}
