const app = getApp();
Component({
  properties: {
    // 这里定义了innerText属性，属性值可以在组件使用时指定
    innerText: {
      type: String
      // value: '',
    },
    list: {
      type: Array
    },
    datas: {
      type: Object
    }
  },
  data: {
    // 这里是一些组件内部数据
    message: "Hello World",
    indicatorDots: false,
    vertical: false,
    autoplay: true,
    interval: 3000,
    duration: 500,
    activeIndex: 0,
    bannerHeight: 0,
    firstLoad: false,
    newArr: []
  },
  ready() {
    this.setData({ newArr: this.newList() });
    this.bannerChange({
      detail: {
        current: 0
      }
    });
  },
  methods: {
    newList() {
      return (
        this.data.datas.componentData.imgList.filter(
          item => item.visible == undefined || item.visible == 1
        ) || []
      );
    },
    customMethod() {
      console.log("hello world! I am learning 微信小程序");
    },
    bannerChange(val) {
      let { newArr } = this.data;
      console.log(newArr,'-newArr');
      let { changeHomePageFlag } = this.data.datas.componentData;
      // 如果开启了修改首页背景图
      let imageUrl = `url(${
        newArr[val.detail.current].imageUrl
        }?x-oss-process=image/blur,r_50,s_50)`;
      if (changeHomePageFlag && app.setHomeBgImg) {
        if (newArr[val.detail.current].imgRgb) {
          app.setHomeBgImg({
            backgroundImage: imageUrl,
            imgRgb: newArr[val.detail.current].imgRgb
          });
        }
      }
      this.setData({ activeIndex: val.detail.current });
    },
    onClick(data) {
      let item = data.currentTarget.dataset.item;
      console.log(data.currentTarget.dataset.item, "iiii");
      app.trackCpn(data, this.data.datas.componentName, item);
      app.$themeToLink(item.link);
    },
    loadImg(e) {
      let { firstLoad } = this.data;
      if (firstLoad == true) {
        return;
      }
      firstLoad = true;
      let winWid =
        wx.getSystemInfoSync().windowWidth -
        this.data.datas.componentData.paddingList[2].value -
        this.data.datas.componentData.paddingList[3].value; //获取当前屏幕的宽度
      let imgh = e.detail.height; //图片高度
      let imgw = e.detail.width;
      let swiperH = winWid * imgh / imgw + "px";
      this.setData({ bannerHeight: swiperH, firstLoad }); //设置高度
    }
  }
});
