// static/nativeComponents/CubeNav/index.js
const app = getApp()
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    datas: {
      type: Object
    }
  },

  /**
   * 组件的初始数据
   */
  data: {
    imgList: [],
    getColumnWidth: '',
    getImgSize: 0,
    navShow: false,
    wrapW: 0,
    w: 0,
    swiperList: [],
    swiperItemW: 0,
    navLeft: 0,
    cube2W: 0,
    cube3H: 0,
    navListStyle: [],
    isLoading: false,
  },
  ready() {
    this.init()
  },

  /**
   * 组件的方法列表
   */
  methods: {
    init() {

      let _this = this;

      let columnWidthArr = ['100%', '50%', '33.3%', '25%', '20%', '16.6%']

      this.data.datas.componentData.imgList.forEach(item => {
        item.imageUrl = item.imageUrl ? app.DFSImg(item.imageUrl,400,400) : ''
      })
      this.setData({
        imgList: this.data.datas.componentData.imgList.filter(item => item.visible == undefined || item.visible == 1),
        getColumnWidth: columnWidthArr[this.data.datas.componentData.columnNum - 1],
        getImgSize: (100 - this.data.datas.componentData.imgSize) / 2,
        navListStyle: [this.navListStyleFun(0), this.navListStyleFun(1), this.navListStyleFun(2)],
        isLoading: true,
      })
      console.log(this.data.navListStyle,'----navListStyle')

      let arr = []
      let count = this.data.datas.componentData.columnNum * this.data.datas.componentData.rowNum;
      let num = Math.ceil(this.data.imgList.length / count);
      for (let i = 0; i < num; i++) {
        arr.push([]);
      }
      this.data.imgList.forEach((item, index) => {
        let i = Math.floor(index / count);
        arr[i].push(item);
      });

      this.setData({
        swiperList: arr
      })

      this.createSelectorQuery().select('.cube-item').boundingClientRect(function(res) {
        console.log('swiper-wrap', res)
        if (res) {
          if (_this.data.datas.componentData.rowNum == 1){
            _this.setData({
              cube3H: res.height * _this.data.datas.componentData.rowNum
            })
          } else if (_this.data.datas.componentData.rowNum == 2){
            if(_this.data.imgList.length / _this.data.datas.componentData.columnNum > 1){
              _this.setData({
                cube3H: res.height * _this.data.datas.componentData.rowNum
              })
            }else{
              _this.setData({
                cube3H: res.height * 1
              })
            }
          } else if (_this.data.datas.componentData.rowNum == 3){
            if (_this.data.datas.componentData.columnNum == 1){
              _this.setData({
                cube3H: res.height * (_this.data.imgList / _this.data.datas.componentData.rowNum)
              })
            }else{
              _this.setData({
                cube3H: res.height * (Math.ceil(_this.data.imgList.length / _this.data.datas.componentData.columnNum))
              })
            }
          }
        }

      }).exec()

      console.log('轮播图swiperList', this.data.swiperList)

      this.createSelectorQuery().select('.cube2').boundingClientRect(function(res) {
        console.log('来这里了', res)
        if (res) {
          let cube2W = res.width

          _this.setData({
            cube2W: cube2W
          })
          let wArr = [cube2W / 1, cube2W / 2, cube2W / 3, cube2W / 4, cube2W / 5, cube2W / 6]


          if (
            Math.floor(
              _this.data.imgList.length /
              (_this.data.datas.componentData.columnNum * _this.data.datas.componentData.rowNum)
            ) == 0
          ) {
            _this.setData({
              wrapW: cube2W
            })
          } else {
            _this.setData({
              wrapW: Math.floor(
                  _this.data.imgList.length /
                  (_this.data.datas.componentData.columnNum * _this.data.datas.componentData.rowNum)
                ) *
                cube2W + (_this.data.imgList.length %
                  (_this.data.datas.componentData.columnNum *
                    _this.data.datas.componentData.rowNum)) *
                wArr[_this.data.datas.componentData.columnNum - 1]
            })
          }
          _this.setData({
            w: wArr[_this.data.datas.componentData.columnNum - 1]
          })
          console.log(_this.data.w)
          if (_this.data.wrapW > cube2W) {
            _this.setData({
              navShow: true
            })
          } else {
            _this.setData({
              navShow: false
            })
          }
        }
      }).exec()
    },
    navListStyleFun(index) {
      let item = this.data.datas.componentData.navList[index];
      return `--t-font-size:${item.tFontSize*2}rpx;--t-color:${item.tColor};--t-weight:${item.tWeight?500:''};--sub-t-font-size:${item.subTFontSize*2}rpx;--sub-t-color:${item.subTColor};--sub-t-weight:${item.subTWeight?500:''};--figure-size:${item.figureSize}%;--figure-border-radius:${item.figureBorderRadius*2}rpx;background-image:url(${item.bgImg});--box-bg-color:${item.boxBgColor};`;
    },
    touchmove(e) {
      let _this = this
      this.debounce(function() {
        let moveX = _this.data.wrapW - _this.data.cube2W;
        _this.createSelectorQuery().select('#wrapW').boundingClientRect(function(res) {
          if (res) {
            let x = Math.abs(res.left) / moveX;
            _this.setData({
              navLeft: 30 * x
            })
          }
        }).exec()
      }, 100)()

    },
    debounce(func, wait) {
      let timeout = "";
      return v => {
        if (timeout) {
          clearTimeout(timeout);
        }
        timeout = setTimeout(() => {
          func(v);
        }, wait);
      };
    },
    onclickHandle(e){
      let item = e.currentTarget.dataset.item
      console.log(item)
      app.trackCpn(e, this.data.datas.componentName, item)
      console.log(item,'---------------------180')
      app.$themeToLink(item.link)
    }
  }
})
