// static/nativeComponents/GoodsSearch/index.js
let app = getApp()
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    datas: {
      type: Object
    }
  },
  /**
   * 组件的初始数据
   */
  data: {
    searchValue: '',
    backgroundColor : '',
    borderColor : '',
    placeholderValue : '',
    searchScopeFlag: 0,
    tableData: [],
    hotWordsInterval: null // 热门词轮播定时任务
  },
  ready(){
    this.setData({
      backgroundColor: this.data.datas.componentData["showStyle"] == 1 &&
        this.data.datas.componentData["backgroundColorShow"] ? this.data.datas.componentData["backgroundColor"] : "rgba(224, 224, 224, 0)",
    })

    if (this.data.datas.componentData["showStyle"] == 0){
      this.setData({
        borderColor : this.data.datas.componentData["borderColorShow"]
          ? this.data.datas.componentData["borderColor"]
          : "rgba(224, 224, 224, 0)"
      })
    }else{
      this.setData({
        borderColor: 'transparent'
      })
    }

    this.setData({
      placeholderValue: this.data.datas.componentData.placeHolderVal ? this.data.datas.componentData.placeHolderVal : '搜索店铺内'
    })

    this.getHotWords()
  },
  detached() {
    clearInterval(this.data.hotWordsInterval)
    this.data.hotWordsInterval = null;
    console.log("销毁",this.data.hotWordsInterval);
  },
  /**
   * 组件的方法列表
   */
  methods: {
    getHotWords() {
      app.goodsApi.getHotWordsApi({}).then(({data:{data}})=>{
        if (data) {
          function compare(property) {
            return function(a, b) {
              var value1 = a[property];
              var value2 = b[property];
              return value1 - value2;
            };
          }
          data.sort(compare("sequenceNumber"));
          this.setData({tableData:data})
          if(this.data.datas.componentData.hotWordsData["isOpenHotWords"] == 1) {
            this.hotWordsCarousel();
          }
        }
      })
    },
    // 热门词轮播方法
    hotWordsCarousel() {
      console.log("调用定时渲染任务2");
      if(this.data.tableData.length > 0) {
        let currentIndex = 0; // 当前取到的元素下标
        // 初始化placeholderVal
        const placeHolderVal = 'datas.componentData.placeHolderVal'
        this.setData({
          [placeHolderVal]:this.data.tableData[0].popularWordsName, // 用于搜索
          placeholderValue:this.data.tableData[0].popularWordsName // 用于显示
        })
        this.data.hotWordsInterval = setInterval(()=>{
          // 取出下一个元素
          currentIndex = (currentIndex + 1) % this.data.tableData.length;
          // console.log("有无",this.data.tableData[currentIndex].popularWordsName);
          this.setData({
            [placeHolderVal]:this.data.tableData[currentIndex].popularWordsName,
            placeholderValue:this.data.tableData[currentIndex].popularWordsName
          })
        }, 5000);
      }
    },
    toSearchPage(e){
      if (this.data.datas.componentData['searchModel'] == 1) return;
      app.trackCpn(e, this.data.datas.componentName)
      const placeHolderText = this.data.datas.componentData["placeHolderVal"] || "";
      let query = `?placeHolderText=${placeHolderText}`;
      let link = `/contentSearch/contentSearch${query}`;
      app.$themeToLink({ type: 1, link });
    },
    // 全网搜和本店搜
    toSearchAllOrLocal() {
      const placeHolderText = this.data.datas.componentData["placeHolderVal"] || "";
      const query = `?placeHolderText=${placeHolderText}&searchScopeFlag=${this.data.searchScopeFlag}&search_txt=${this.data.searchValue}`;
      let link = `/goodsSearch/goodsSearch${query}`;
      if (this.data.searchScopeFlag == 0) {
        link = `/goodsSearch/searchAllGoods${query}`;
      }
      app.$themeToLink({ type: 1, link });
    },
    // 本店搜
    handleSearchLocal() {
      this.setData({ searchScopeFlag: 1 });
      this.toSearchAllOrLocal();
    },
    // 全网搜
    handleSearchAll() {
      this.setData({ searchScopeFlag: 0 });
      this.toSearchAllOrLocal();
    },
    onInput(e) {
      this.setData({ searchValue: e.detail.value });
    },
    // 扫码搜功能
    handleScan() {
      app.themeScanningCodeClick();
    }
  }
})
