// static/nativeComponents/Notice/index.js
const app = getApp();
const { DFSImg, $themeToLink } = app;
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    datas : {
      type : Object
    }
  },

  /**
   * 组件的初始数据
   */
  data: {
    singleImg: '',
    CommonHeight: 0,
    NoticeMargin: 0,
    NoticePadding: 0
  },

  ready() {
    let { noticeList, singleImage } = this.data.datas.componentData
    singleImage = DFSImg(singleImage)
    for (let i = 0; i < noticeList.length; i++) {
      let imageUrl = DFSImg(noticeList[i].imageUrl)
      noticeList[i].imageUrl = imageUrl
    }
    this.setData({
      singleImg: singleImage,
      "data.datas.componentData.noticeList": noticeList
    })
    this.getNoticeHeight()
    this.getNoticeMargin()
    this.getNoticePadding()
  },

  /**
   * 组件的方法列表
   */
  methods: {
    onclickHandle(e) {
      let item = this.data.datas.componentData.noticeList[e.currentTarget.dataset.index]
      app.trackCpn(e, this.data.datas.componentName, item)
      app.$themeToLink(item.link)
    },
    getNoticeMargin() {
      this.setData({
        NoticeMargin: this.data.datas.componentData.verticalMargin+'px '+this.data.datas.componentData.horizontalMargin+'px'
      })
    },
    getNoticePadding() {
      this.setData({
        NoticePadding: this.data.datas.componentData.verticalPadding+'px '+this.data.datas.componentData.horizontalPadding+'px'
      })
    },
    getNoticeHeight() {
      if (this.data.datas.componentData.isChange) {
        if (this.data.datas.componentData.imageWidth > this.data.datas.componentData.noticeWidth) {
          this.setData({
            CommonHeight: this.data.datas.componentData.imageWidth < 24 ? '24px' : this.data.datas.componentData.imageWidth + 'px'
          })
          return
        } else if (this.data.datas.componentData.noticeWidth >= this.data.datas.componentData.imageWidth) {
          this.setData({
            CommonHeight: this.data.datas.componentData.noticeWidth < 24 ? '24px' : this.data.datas.componentData.noticeWidth + 'px'
          })
          return
        }
        this.setData({
          CommonHeight: this.data.datas.componentData.noticeWidth > this.data.datas.componentData.imageWidth ? this.data.datas.componentData.noticeWidth + 'px' : this.data.datas.componentData.imageWidth + 'px'
        })
        return
      } else {
        this.setData({
          CommonHeight: this.data.datas.componentData.noticeWidth < 24 ? '24px' : this.data.datas.componentData.noticeWidth + 'px'
        })
        return
      }
    }
  }
})
