const app = getApp();
const { goodsApi, DFSImg, $themeToLink } = app;

Component({
  behaviors: [],
  properties: {
    datas : {
      type : Object
    }
  },
  data: {
    rankingInfoA: {},
    rankingInfoB: {},
    rankingList: [],
    rankingListA: [],
    rankingListB: []
  },
  ready() {
    this.setData({ rankingInfoA: this.data.datas.componentData.rankingInfoA });
    this.setData({ rankingInfoB: this.data.datas.componentData.rankingInfoB });
    this.getRankingList();
  },
  observers: {
    rankingListA() {
      this.notifyRankingList()
    },
    rankingListB() {
      this.notifyRankingList()
    }
  },
  methods: {
    handleItemClick(e) {
      const item = e.currentTarget.dataset.item;
      $themeToLink({
        type: 1,
        link: `/goods/${item.productId}?terminalProductId=${item.terminalProductId}`
      });
    },
    notifyRankingList() {
      const rankingInfoA = this.data.rankingInfoA;
      const rankingInfoB = this.data.rankingInfoB;
      if (rankingInfoA.checked && rankingInfoB.checked) {
        const listA = this.data.rankingListA.slice(0, 2);
        const listB = this.data.rankingListB.slice(0, 2);
        this.setData({ rankingList: listA.concat(listB) });
      } else if (rankingInfoA.checked) {
        this.setData({ rankingList: this.data.rankingListA })
      } else if (rankingInfoB.checked) {
        this.setData({ rankingList: this.data.rankingListB });
      }
    },
    
    async getRankingList() {
      const rankingInfoA = this.data.rankingInfoA;
      const rankingInfoB = this.data.rankingInfoB;
      // 开启两个榜单
      if (rankingInfoA.checked) {
        this.getProductInfo(0, rankingInfoA.filter);
      }
      if (rankingInfoB.checked) {
        this.getProductInfo(1, rankingInfoB.filter);
      }
    },
    
    async getProductInfo(type, id) {
      const data = {
        categoryIncludeChild: true,
        categoryId: id,
        page: 1, // 当前页
        rows: 4,
        sortColumn: this.goodsSort,
        sortType: 1,
        whetherShowSoldOutGoods: false, //查询销售数量
        whetherQueryCollectCount: false, //查询收藏数
        whetherUseVirtualSalesQty: false, //是否使用虚拟销售数量
        whetherUseVirtualCollectCount: false, //是否使用虚拟收藏人数
        whetherFindDistributionCommission: 0, //是否查询商品佣金（0：不查询，1：展示，为空不查佣金）
        whetherFindRecommendedCardFlag: 0, //是否查询会员价  1是  0否
        whetherShowGoodsDefaultTagFlag: 0, //是否展示营销标签  1是  0否
        whetherFindMultiShopFlag:1, //是否查询多商户   //商城使用
        whetherFindMultiSonShopFlag:1, //是否查询多商户   //多主题使用
        brandIdList: [],
        categoryIdList: [],
        whetherQueryGoodsAttributeFlag: 0,
        whetherToEnableQuickPurchase: 0,
      }
      const res = await goodsApi.queryProductInfo(data);
      if (res.data.code == 200) {
        res.data.data.list && res.data.data.list.forEach(item => {
          item.productImgUrl = DFSImg(item.productImgUrl);
        })
        if (!type) {
          this.setData({ rankingListA: res.data.data.list || [] });
        } else {
          this.setData({ rankingListB: res.data.data.list || [] });
        }
      }
    }
  },
});