const app = getApp();
const { $themeToLink, processEnv, globalData, concatUrl } = app;
const componentOptions = {
  // 组件选项
  options: {
    multipleSlots: true
  },
  behaviors: [],
  properties: {},
  // 组件数据
  data: {
    isPageHidden: false, // 页面是否处于隐藏状态
    showPop: false,
    custom: {
      textShow: 1,
      itemList: [1, 1, 1],
      itemListInfo: [],
      href: "",
      toPage: "", //跳转的页面
      callback: "", //回调函数
      extends: {} //额外参数
    },
    distributorVal: "",
    type: 0,
    phone: "",
    href: "",
    posterId: -1,
    spokesmanGroupId: "",
    spokesmanShopId: "",
    spokesmanRelId: "",
    hasInvitationStatus: 0,
    nickname: "",
    shareGoodsInfo: {},

    giftIsSend: false,
    miniProgram: 0,
    flag: false,
    productId: "",
    copyLink: ""
  },
  // 数据监听器
  observers: {},
  // 组件方法
  methods: {
    init() {
      let _this = this;
      let { custom } =this.data;
      app.shareInit = function(list) {
        for (const key in list) {
          if (list.hasOwnProperty(key)) {
            if (custom[key] !== "undefined" && custom[key] !== undefined && list[key] !== "undefined" && list[key] !== undefined) {
              custom[key] = list[key];
            }
          }
        }
        _this.setData({ custom });
        _this.showPopup();
      };
    },
    showPopup() {
      this.setData({ showPop: true });
    },

    onClose() {
      this.setData({ showPop: false });
    },
    cancel() {
      this.onClose();
    },
    copyText(e) {
      app.trackCpn(e, '首页分享', '复制链接')
      let pagePath = `${processEnv.BASE_URL}?mixid=${globalData.shopInfo.shopCode}`;
      let copyVal = pagePath;
      app.fenxiaoModel.getSpokesmanidByShare().then(res=>{
        if (res.hasInvitationStatus == 1) {
          copyVal = concatUrl(copyVal,res)
        }
        console.log(copyVal,11111222)
        wx.setClipboardData({
          data: copyVal,
          success: function(res) {
            wx.getClipboardData({
              success: function(res) {
                wx.showToast({ title: "复制成功" });
              }
            });
          }
        });
      })
    },
    toPosters(e) {
      app.trackCpn(e, '首页分享', '生成海报')
      let userInfo = wx.getStorageSync("userInfo") ? JSON.parse(wx.getStorageSync("userInfo")):'';
      let queryHref = `${processEnv.BASE_URL}?mixid=${globalData.shopInfo.shopCode}`;
      app.fenxiaoModel.getSpokesmanidByShare().then(res=>{
        if (res.hasInvitationStatus == 1) {
          queryHref = concatUrl(queryHref,res)
        }
        let linkVal = `/goods/posters?type=index&href=${queryHref}`;
        if (userInfo) {
          linkVal += `&nickname=${userInfo.nickName}`;
        }
        console.log(linkVal, "------------------linkVal");
        $themeToLink({ type: 1, link: linkVal });
      })
    },
  },
  // 组件生命周期
  lifetimes: {
    created() {},
    attached() {
      this.init();
    },
    ready() {},
    moved() {},
    detached() {}
  },
  definitionFilter() {},
  // 页面生命周期
  pageLifetimes: {
    // 页面被展示
    show() {
      const { isPageHidden } = this.data;

      // show事件发生前，页面不是处于隐藏状态时
      if (!isPageHidden) {
        return;
      }

      // 重新执行定时器等操作
    },
    // 页面被隐藏
    hide() {
      this.setData({
        isPageHidden: true
      });

      // 清除定时器等操作
    },
    // 页面尺寸变化时
    resize() {}
  }
};

Component(componentOptions);
