// static/nativeComponents/SpeedyNav/index.js
const app = getApp();
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    datas:{
      type : Object
    }
  },

  /**
   * 组件的初始数据
   */
  data: {
    getTypeStyle: 'across',
    categoryList : [],
    targetShow: true,
    loading: false,
    getColumnWidth : '',
    getStyle : ''
  },

  ready(){
    this.setData({
      getTypeStyle: this.data.datas.componentData.typeStyle
    })

    let arr = ['50%', "33.3%", "25%", "20%", "16.6%"]

    this.setData({
      getColumnWidth: arr[this.data.datas.componentData.columnNum - 2]
    })

    if (this.data.datas.componentData.style == 'circle'){
      this.setData({
        getStyle : '20%'
      })
    } else if (this.data.datas.componentData.style == 'rect'){
      this.setData({
        getStyle: '0'
      })
    } else if (this.data.datas.componentData.style == 'whole-circle'){
      this.setData({
        getStyle: '50%'
      })
    }

    app.indexApi.get_product_category({
      whetherShowSoldOutGoods: null
    }).then(res => {
      if (res.data.code == 200 && res.data.data.category[0] && res.data.data.category[0].children){
        this.setData({
          loading : true
        })
        res.data.data.category[0].children.forEach(item => {

          if (item.categoryBigImg) {
            item.categoryBigImg = app.DFSImg(item.categoryBigImg,400,400)
          }
          if (item.categoryImgUrl) {
            item.categoryImgUrl = app.DFSImg(item.categoryImgUrl,400,400)
          }


        })

        console.log(res.data.data.category[0].children, 'res.data.data.category[0].children')

        this.setData({
          categoryList: res.data.data.category[0].children
        })
        if (this.data.categoryList.length == 0) {
          this.setData({
            targetShow: false
          })
        }
      }
    })


  },
  /**
   * 组件的方法列表
   */
  methods: {
    onclick(e){
      let item = e.currentTarget.dataset.item
      app.trackCpn(e, this.data.datas.componentName, item)
      app.$themeToLink({
        type: 1,
        link: `/goods/commodityMenu?categoryName=${item.categoryName}&categoryId=${item.id}`
      })
    }
  }
})
