const app = getApp();
export default {
  computed: {
    getBorderRadius() {
      return this.datas.componentData.borderRadius == undefined
        ? 0.625
        : this.datas.componentData.borderRadius;
    },
    goodsSort() {
      return this.datas.componentData.goodsSort || 0;
    },
    // 会员价
    vipPrice() {
      return this.datas.componentData.vipPrice || false;
    },
    whetherFindDistributionCommission() {
      return this.datas.componentData.whetherFindDistributionCommission ? 1 : 0;
    },
    categoryId() {
      return this.datas.componentData.categoryId
        ? this.datas.componentData.categoryId
        : "";
    },
    // 关注人数样式
    followerColor() {
      return this.datas.componentData.followerColor
        ? this.datas.componentData.followerColor
        : "#ff9933";
    },
    // 佣金文字颜色
    commissionColor() {
      return this.datas.componentData.commissionColor
        ? this.datas.componentData.commissionColor
        : "#ff9051";
    },
    //佣金背景颜色
    commissionBgColor() {
      return this.datas.componentData.commissionBgColor
        ? this.datas.componentData.commissionBgColor
        : "";
    },
    // 按钮图标
    btnIcon() {
      return this.datas.componentData.btnIcon
        ? this.datas.componentData.btnIcon
        : "";
    },
    // 按钮类型
    btnType() {
      return this.datas.componentData.btnType
        ? this.datas.componentData.btnType
        : 6;
    },
    // 按钮颜色
    btnColor() {
      return this.datas.componentData.btnColor
        ? this.datas.componentData.btnColor
        : "var(--main-color)";
    },
    // 按钮文案
    btnTest() {
      return this.datas.componentData.btnTest
        ? this.datas.componentData.btnTest
        : "立即购买";
    },
    getItemNum() {
      return this.datas.componentData.goodsList;
    },
    getPaddingList() {
      return this.datas.componentData.paddingList;
    },
    getColumnWidth() {
      if (this.datas.componentData.columnNum == 1) {
        return "100%";
      } else if (this.datas.componentData.columnNum == 2) {
        return "50%";
      } else {
        return "33.3%";
      }
    },
    getPayFontSize() {
      if (this.datas.componentData.columnNum == 1) {
        return "12px";
      } else if (this.datas.componentData.columnNum == 2) {
        return "10px";
      } else {
        return "8px";
      }
    },
    getListPadding() {
      if (this.datas.componentData.columnNum == 1) {
        return "";
      } else if (this.datas.componentData.columnNum == 2) {
        return (
          "0 " +
          this.datas.componentData.proGap / 2 +
          "px" +
          " 0 " +
          this.datas.componentData.proGap / 2 +
          "px"
        );
      } else {
        return "33.3%";
      }
    },
    whetherShowSoldOutGoods() {
      // 商城端接口的获取商城配置信息
      // if (this.render) {
      //   return this.$store.state.setShopConfig.whetherShowSoldOutGoods || 1;
      // } else {
      //   return 1;
      // }
      return 1;
    },
    goodsType() {
      return this.datas.componentData.goodsType || 0;
    },
    // 展示标题图片
    titleIcon() {
      return app.DFSImg(this.datas.componentData.titleIcon, 400, 400) || "";
    },
    // 展示角标
    angleSign() {
      return this.datas.componentData.angleSign || false;
    },
    // 角标尺寸
    angleSignSize() {
      return this.datas.componentData.angleSignSize || 25;
    },
    // 展示角标图片
    angleSignImg() {
      return this.datas.componentData.angleSignImg || "";
    },
    // 展示营销标签
    marketingTag() {
      return this.datas.componentData.marketingTag || false;
    },
    // 展示营销标签类型
    marketingStyle() {
      return this.datas.componentData.marketingStyle || 0;
    },
    // 营销标签列表
    marketingTagList() {
      return this.datas.componentData.marketingTagList || [];
    },
    cardShadowSize() {
      return this.datas.componentData.cardShadowSize
        ? this.datas.componentData.cardShadowSize
        : 3;
    }
  }
};