// static/nativeComponents/PopUp/index.js
let app = getApp()
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    datas:{
      type:Object
    }
  },

  

  /**
   * 组件的初始数据
   */
  data: {
    timeout: null,
    domainShow: false,
    img : ''
  },
  detached(){
    clearTimeout(this.data.timeout);
  },

  ready() {

    this.setData({
      img: app.DFSImg(this.data.datas.componentData.imageUrl,700,null,1)
    })
    
    console.log(this.data.datas.componentData,'this.data.datas.componentData.once')
    if(!this.data.datas.componentData.once){
      console.log('laizhelile')
      let routes = getCurrentPages()
      let page = routes[routes.length - 1].route
      wx.removeStorageSync(`${app.globalData.shopInfo.shopCode}_popFlag_${page}_${this.data.datas.id}`)
    }
    if (this.getPopFlag() == 'true'){
      this.setData({
        domainShow : false
      })
    }else{
      this.setData({
        domainShow: true
      })

      if (this.data.datas.componentData.columnNum > 0 && this.data.datas.componentData.autoOff){
        clearTimeout(this.data.timeout);
        this.data.timeout = setTimeout(() => {
          this.setData({
            domainShow: false
          })
          if(this.data.datas.componentData.once){
            this.setPopFlag('true')
          }
        }, this.data.datas.componentData.columnNum * 1000)
      }
    }
  },

  /**
   * 组件的方法列表
   */
  methods: {
    getPopFlag() {
      let routes = getCurrentPages()
      let page = routes[routes.length - 1].route
      return wx.getStorageSync(`${app.globalData.shopInfo.shopCode}_popFlag_${page}_${this.data.datas.id}`)
      
    },
    setPopFlag(value) {
      app.globalData.setPopupStorage = 1;
      let routes = getCurrentPages()
      let page = routes[routes.length - 1].route
      wx.setStorageSync(`${app.globalData.shopInfo.shopCode}_popFlag_${page}_${this.data.datas.id}`, value)
      let popUpList =  wx.getStorageSync('popUpList') || [];
      popUpList.push(`${app.globalData.shopInfo.shopCode}_popFlag_${page}_${this.data.datas.id}`)
      wx.setStorageSync('popUpList', popUpList)
      console.log(app.globalData)
    },
    backHandle(){
      this.setData({
        domainShow : false
      })
      if(this.data.datas.componentData.once){
        this.setPopFlag("true");
      }
      
      clearTimeout(this.data.timeout);
    },
    onclickHandle() {
      app.$themeToLink(this.data.datas.componentData.link);
    }
  }
})
