const app = getApp();
const componentOptions = {
  // 组件选项
  options: {
    multipleSlots: true
  },
  behaviors: [],
  properties: {
    datas: {
      type: Object
    },
    indexs: {
      type:Number
    }
  },
  // 组件数据
  data: {
    isPageHidden: false, // 页面是否处于隐藏状态
    isPlay: false,
    videoContext: "",
    firstPlay: false,
  },
  // 数据监听器
  observers: {},
  // 组件方法
  methods: {
    init() { },
    getScroll(el) {
      let { autoPlay, scrollPlay } = this.data.datas.componentData;
      if (!scrollPlay) return;
      let query = wx.createSelectorQuery();
      query.select('.VideoPlayer'+this.data.indexs).boundingClientRect(rect=>{
        console.log(rect,'----------rect')
        let videoPlayerTop = Math.ceil(rect.top);
        let videoPlayerHeight = rect.height;
        const sysInfo = wx.getSystemInfoSync()
        let windowHeight = sysInfo.windowHeight / 2;
        if ((videoPlayerTop <= windowHeight) && (videoPlayerTop + videoPlayerHeight > windowHeight)) {
          console.log("开始播放");
          this.autoVideo(0);
        } else {
          // 距离顶部高度绝对值大于组件高度即为在可视范围外
          console.log("暂停播放");
          this.autoVideo(1);
        }
      }).exec();
    },
    autoVideo(type) {
      if (type == 0) {
        // 开始播放
        this.videoContext.play();
        this.setData({ isPlay: true,firstPlay:true });
      } else if (type == 1) {
        // 暂停播放
        this.videoContext.pause();
        this.setData({ isPlay: false });
      }
    },
    playVideo(e) {
      app.trackCpn(e, this.data.datas.componentName)
      // 视频播放
      if (this.data.datas.componentData['nativeControl']) {
        return
      }
      let { isPlay } = this.data;
      if (isPlay) {
        console.log("暂停")
        this.videoContext.pause();
      } else {
        console.log("播放")
        this.videoContext.play();
      }
      isPlay = !isPlay;
      this.setData({ isPlay,firstPlay: true });
    }
  },
  // 组件生命周期
  lifetimes: {
    created() {
    },
    attached() {
      this.init();
    },
    ready() {
      this.videoContext = wx.createVideoContext(`videoId${this.data.indexs}`,this);
      if (this.data.datas.componentData['autoPlay']) {
        this.setData({isPlay: true})
      }
      console.log(this.videoContext,'---this.videoContext')
    },
    moved() {},
    detached() {}
  },
  definitionFilter() {},
  // 页面生命周期
  pageLifetimes: {
    // 页面被展示
    show() {
      const { isPageHidden } = this.data;

      // show事件发生前，页面不是处于隐藏状态时
      if (!isPageHidden) {
        return;
      }

      // 重新执行定时器等操作
    },
    // 页面被隐藏
    hide() {
      this.setData({
        isPageHidden: true
      });

      // 清除定时器等操作
    },
    // 页面尺寸变化时
    resize() {}
  }
};

Component(componentOptions);
