const app = getApp();
Component({
  properties: {
    selected: {
      type: Number,
      default: -1
    }
  },
  data: {
    // selected: -1,
    color: "#7A7E83",
    selectedColor: "#3cc51f",
    list: [
    ],
    mid: '',
    componentData: {},
    show: true,
    mainColor: "",
    showFlag: "up",
    cartNum: 0
  },
  attached() {
    this.init()
  },
  methods: {
    init() {
      if (app.themeColor["--main-color"] != "#ffffff") {
        this.setData({
          mainColor: app.themeColor["--main-color"]
        });
      } else {
        app.themeColorCallBack = res => {
          this.setData({
            mainColor: res["--main-color"]
          });
        };
      }
      // 
      let that = this;
      if (app.globalData.footerVal) {
        let { componentData } = app.globalData.footerVal;
        let mid = Math.ceil(app.globalData.footerVal.componentData.list.length / 2 - 1)
        console.log(app.globalData.footerVal.componentData,'-------app.globalData.footerVal.componentData')
        componentData.list.forEach(item => {
          item.isAntt = item.icon.includes('ant-')
          console.log('isAntt', item.isAntt)
        })
        // 处理默认样式
        // 未选中
        if (componentData.defaultText == 1) {
          componentData.defaultTextColor = "#333";
          componentData.defaultTextNum = 10;
        }
        if (componentData.defaultIcon == 1) {
          componentData.defaultIconColor = "#333";
          componentData.defaultIconSize = 18;
        }
        // 选中
        if (componentData.selectText == 1) {
          componentData.selectTextColor = "var(--main-color)";
          componentData.selectionTextNum = 10;
        }
        if (componentData.selectIconBackground == 1) {
          componentData.selectIconColor = "var(--main-color)";
          componentData.selectionIconSize = 18;
        }

        console.log(componentData.list,'componentData.list')
        that.setData({
          componentData: componentData,
          list: componentData.list,
          mid: mid
        });
      } else {
        app.footerCallBack = function (params) {
          params.componentData.selectIconColor = app.globalData.footerVal.componentData.selectIconBackground == 1 ? 'val(--main-color)' : params.componentData.selectIconColor
          let mid = Math.ceil(params.componentData.list.length / 2 - 1)
          
          params.componentData.list.forEach(item => {
            item.isAntt = item.icon.includes('ant-')
            console.log('isAntt', item.isAntt)
          })

          console.log(params.componentData.list,'app.globalData.footerVal.componentData.list')



          that.setData({
            componentData: params.componentData,
            list: params.componentData.list,
            mid: mid
          });
        };
      }
    },
    switchTab(e) {
      const { index } = e.currentTarget.dataset;
      if (index == this.data.selected) return
      app.$themeToLink(this.data.list[index]["link"], 1);
    }
  }
});
