function formatNumber(n) {
  const str = n.toString()
  return str[1] ? str : `0${str}`
}

//格式时间
export function formatTime(date) {
  const year = date.getFullYear()
  const month = date.getMonth() + 1
  const day = date.getDate()

  const hour = date.getHours()
  const minute = date.getMinutes()
  const second = date.getSeconds()

  const t1 = [year, month, day].map(formatNumber).join('/')
  const t2 = [hour, minute, second].map(formatNumber).join(':')

  return `${t1} ${t2}`
}

//对象转querystring
export function serialize(obj) {
  var str = [];
  if (typeof obj == "string") {
    obj = JSON.parse(obj);
  }
  for (var p in obj) {
    if (obj.hasOwnProperty(p)) {
      str.push(encodeURIComponent(p) + "=" + encodeURIComponent(obj[p]));
    }
  }
  return str.join("&");
}


//获取url参数
export function getQueryVariable(query,variable) {
  // var query = window.location.search.substring(1);
  var vars = query.split("&");
  for (var i = 0; i < vars.length; i++) {
    var pair = vars[i].split("=");
    if (pair[0] == variable) { return pair[1]; }
  }
  return (false);
}

//补全图片路径
export function DFSImg(path, w, h) { //
  // if (path == null || path == '') {
  //   return require('~/static/images/noImg.png');
  // }
  let baseImg = process.env.IMG_DOMAIN ;
  if (!Array.isArray(baseImg) && (baseImg.indexOf('aliyun') >= 0 || baseImg.indexOf('cdn') >= 0 )) {
    var style = '';
    if (w) style += ',w_' + w;
    if (h) style += ',h_' + h;
    if (style.length > 0) {
      if(path.indexOf('?x-oss-process') == -1){
        path += '?x-oss-process=image/resize,m_pad,limit_0' + style
      }
    }
    if (path.indexOf('http') == 0) {
      return path;
    }
    return baseImg + path;
  } else {
    if (path.indexOf('http') == 0) {
      return path;
    }
    if (path.indexOf('/') != 0) {
      path = '/' + path;
    }
    if (w && h) {
      path += '.' + w + 'x' + h + '.jpg';
    }

    return baseImg[Math.floor(Math.random() * 100) % baseImg.length] + path;
  }
}
// 获取Navbar高度
export function getNavbarInfo(fn) {
  let menuInfo = wx.getMenuButtonBoundingClientRect(); //右上角胶囊信息
  wx.getSystemInfo({
    success: (res) => {
      fn({
        navTop: res.statusBarHeight, //状态栏高度
        navHeight: res.statusBarHeight + menuInfo.height + (menuInfo.top - res.statusBarHeight) * 2 //导航栏高度
      })
    }
  })
}


export function setTimes(value){
  let result = parseInt(value)
　　let h = Math.floor(result / 3600) < 10 ? '0' + Math.floor(result / 3600) : Math.floor(result / 3600)
　　let m = Math.floor((result / 60 % 60)) < 10 ? '0' + Math.floor((result / 60 % 60)) : Math.floor((result / 60 % 60))
　　let s = Math.floor((result % 60)) < 10 ? '0' + Math.floor((result % 60)) : Math.floor((result % 60))
　　result = `${h}:${m}:${s}`
　　return result
}