import { requestPOST, requestPOST1 } from "@/utils/request.js";

export default {
  getShopInfo() {
    return requestPOST(`${process.env.OLSHOP_URL}/shop/get_shop_info`);
  },
  getWxMiniSubscribeMessageConfig() {
    return requestPOST(
      `${process.env.OLSHOP_URL}/shop/getWxMiniSubscribeMessageConfig`
    );
  },
  addWxMiniSubscribeMessageRecord(data) {
    return requestPOST(
      `${process.env.OLSHOP_URL}/shop/addWxMiniSubscribeMessageRecord`,
      data
    );
  },
  //  页面数据
  themePagesInfo(params) {
    return requestPOST(`${process.env.OLSHOP_URL}/cms/get_shop_install_pages?homePageFlag=${params.homePageFlag || false}&shopMixId=${params.shopMixId}`,
    );
  },
  checkShowCondition(params) {
    return requestPOST(
      `${process.env.OLSHOP_URL}/cms/check_show_condition`,
      params
    );
  },
  // 获取新版会员卡列表
  getV3CardList(params) {
    return requestPOST(`${process.env.OLSHOP_URL}/user/membership_card_list`, {
      params
    });
  },
  // 领取新版无门槛会员卡
  drawV3Card(params) {
    return requestPOST(
      `${process.env.OLSHOP_URL}/user/draw_membership_card?cardId=${params}`
    );
  },

  //获取shop配置
  get_shop_configuration() {
    return requestPOST(`${process.env.OLSHOP_URL}/shop/get_shop_configuration`);
  },
  // 获取系统配置
  get_system_config_by_code(params) {
    return requestPOST(
      `${process.env.OLSHOP_URL}/common/get_system_config_by_code?code=${
        params.code
      }`
    );
  },
  // 首页获取线下门店列表
  getThousandsStoresOfflineStore(data) {
    return requestPOST(
      `${process.env.OLSHOP_URL}/shop/get_thousands_stores_offline_store`,
      data
    );
  },
  // 获取线下门店详情
  getOfflineStoreDetail(data) {
    return requestPOST(
      `${process.env.OLSHOP_URL}/shop/get_offline_store_detail?shopId=${data.shopId}`);
  },
  // 首页获取线下门店列表v2
  changingOverShopForXinHua(data) {
    return requestPOST(
      `${process.env.OLSHOP_URL}/shop/changingOverShopForXinHua`,
      data
    );
  },
  // 保存进店记录
  saveEnterShopRecord(data) {
    return requestPOST(
      `${process.env.OLSHOP_URL}/enterShopRule/saveEnterShopRecord`,
      data
    );
  },
  // 进店规则获取门店id
  getEnterShopId(data) {
    return requestPOST(
      `${process.env.OLSHOP_URL}/enterShopRule/getEnterShopId`,
      data
    );
  },
};
