const app = getApp();
const { goodsApi, DFSImg, $themeToLink, $themeAddToCard,log } = app;

const componentOptions = {
  // 组件选项
  options: {
    multipleSlots: true
  },
  behaviors: [],
  properties: {
    datas: {
      type: Object
    },
    items: {
      type: Object
    },
    indexs: {
      type: Number
    }
  },
  // 组件数据
  data: {
    isPageHidden: false, // 页面是否处于隐藏状态
    timeData: {},
    imgFillType: "widthFix",
    secKillTimer1: null,
    secKillTimer2: null,
    secRestTime: {}, // 秒杀倒计时
    isBeginSecKill: false, // 是否开始秒杀
    isLessTenHour: false, // 秒杀活动小于 10 小时
    currentSecKillInfo: {}, // 当前秒杀信息
    priceTextStyle: 'flex-start'
  },
  // 数据监听器
  observers: {
    items(val) {
      if (val && val.secondKillActivityInfoGoodsList && !this.data.currentSecKillInfo.id) {
        if (val.secondKillActivityInfoGoodsList.length > 0) {
          this.getSecKillInfo(val);
        }
      }
    }
  },
  // 组件方法
  methods: {
    init() {
      let datas = this.data.datas
      let { imgFillType } = this.data;
      if(datas.componentData.angleSignImg && datas.componentData.angleSignImg.lenght != 0){
        datas.componentData.angleSignImg = DFSImg(datas.componentData.angleSignImg,150,150,1)
      }
      if (datas.componentData.style === 'rowList' || datas.componentData.style === 'heap') {
        imgFillType = "aspectFit"
      } else if (datas.componentData.style == 'waterfall' && datas.componentData.imgShowMode == "1") {
        imgFillType = "aspectFill"
      } else {
        imgFillType = "widthFix"
      }
      this.setData({
        datas,
        imgFillType
      })
      log.info('datas');
      const textStyle = {
        'left': 'flex-start',
        'center': 'center',
        'right': 'flex-end'
      };
      this.setData({ priceTextStyle: textStyle[this.data.datas.componentData['priceTextAlign']] })
    },
    // 获取当前秒杀信息
    getSecKillInfo(val) {
      if (val.secondKillActivityInfoGoodsList.length === 0) return;
      const tempObj = val.secondKillActivityInfoGoodsList[0];
      const item = val.goodsItems.find(item => item.goodsId == tempObj.goodsId);
      tempObj.spikePrice = Number(tempObj.spikePrice).toFixed(2);
      tempObj.originPrice = Number(item.salePrice).toFixed(2);
      tempObj.formatTime = this.formatDate(tempObj.startTime);
      this.setData({ currentSecKillInfo: tempObj })
      const timestamp = new Date(this.data.currentSecKillInfo.startTime) - Date.now()
      if (timestamp > 0) {
        this.setData({ isBeginSecKill: false });
        // 判断当前剩余时间是否小于 10 分钟
        if (timestamp < 10 * 60 * 1000) {
          this.calcSecKillIsBeginLoop();
        }
      } else {
        this.setData({ isBeginSecKill: true });
        this.calcSecKillIsLessTenMin();
      }
    },
    // 判断秒杀活动是否开始
    calcSecKillIsBeginLoop() {
      clearTimeout(this.data.secKillTimer1);
      if (this.data.isBeginSecKill) return;
      const secKillTimer1 = setTimeout(() => {
        if (new Date(this.data.currentSecKillInfo.startTime) - Date.now() > 0) {
          this.setData({ isBeginSecKill: true })
        }
      }, 1000);
      this.setData({ secKillTimer1 });
    },
    // 判断秒杀活动是否小于 10 小时
    calcSecKillIsLessTenMin() {
      clearTimeout(this.data.secKillTimer2);
      if (this.data.isLessTenHour) return;
      const secKillTimer2 = setTimeout(() => {
        if (new Date(this.data.currentSecKillInfo.endTime) - Date.now() <= 36000000) {
          this.setData({ isLessTenHour: true });
          this.setData({ currentSecKillInfo: { ...this.data.currentSecKillInfo, restTime: this.getSaleTime(this.data.currentSecKillInfo.endTime) } })
        }
      }, 1000);
      this.setData({ secKillTimer2 })
    },
    formatDate(str) {
      if (!str) return;
      const date = new Date(str.replace(/-/g, '/')); // 将横线替换为斜杠
      const month = date.getMonth() + 1; // 获取月份（注意要加 1）
      const day = date.getDate(); // 获取日期
      const hour = date.getHours(); // 获取小时
      const min = date.getMinutes(); // 获取分钟

      return `${month}月${day}日 ${hour}:${min.toString().padStart(2, '0')}开始`;
    },
    onSecRestTimeChange(e) {
      const detail = e.detail;
      detail.hours = detail.hours.toString().padStart(2, '0');
      detail.minutes = detail.minutes.toString().padStart(2, '0');
      detail.seconds = detail.seconds.toString().padStart(2, '0');
      this.setData({ secRestTime: detail });
    },
    // 秒杀结束
    handleSecFinish() {
      this.setData({ isBeginSecKill: false });
      this.setData({ items: { ...this.data.items, secondKillActivityInfoGoodsList: null } })
    },
    getSaleTime(val) {
      return new Date(val.replace(/-/g, "/")).getTime() - new Date().getTime();
    },
    showVipPrice(index) {
      // 索引 0 显示价格 1显示名称
      let showFlag = false;
      let vipPrice = this.items["minPriceAfterRecommendedCardPriceTable"];
      if (vipPrice && Number(vipPrice) < Number(this.items["minPrice"])) {
        showFlag = true;
      }
      console.log(showFlag, "------------760");
      return showFlag;
    },
    showVipTag(index) {
      // 索引 0 显示价格 1显示名称
      let showFlag = false;
      let vipPrice = this.items["minPriceAfterRecommendedCardPriceTable"];
      let showTag = this.items["recommendedCardMinPricePriceTableName"];
      if (
        vipPrice &&
        showTag &&
        Number(vipPrice) <= Number(this.items["minPrice"])
      ) {
        showFlag = true;
      }
      return showFlag;
    },
    onChange(e) {
      this.setData({ timeData: e.detail });
    },
    onclickProduct(e) {
      let { goodsType } = this.data.datas.componentData;
      let {
        shopName,
        productId,
        productName,
        terminalProductId,
        terminalGoodsMixId
      } = this.data.items;
      let linkVal = "";
      if (goodsType == 0) {
        linkVal = `/goods/${productId}?terminalProductId=${terminalProductId}`;
      } else if (goodsType == 1) {
        linkVal = `/pointShop/goodsDetail?productId${productId}&terminalProductId=${terminalProductId}&terminalGoodsMixId=${terminalGoodsMixId}`;
      }
      app.trackCpn(e, this.data.datas.componentName, {
        shopName,productId,productName,terminalProductId,terminalGoodsMixId
      })
      $themeToLink({
        type: 1,
        link: linkVal
      });
    },
    // 收藏
    toStart(e) {
      let {items} = this.data;
      console.log(this.data.items,e,'----items')
      let query = {
        productId: items.productId,
        terminalProductId: items.terminalProductId,
      }
      if (!items.collectFlag) {
        // 收藏
        goodsApi.collect_goods(query).then(res1 => {
          let res = res1.data;
          if(res.code == 200 && res.data) {
            this.setData({
              "items.collectFlag": !items.collectFlag
            })
          }
        })
      } else {
        // 取消收藏
        goodsApi.uncollect_goods(query).then(res1 => {
          let res = res1.data;
          if(res.code == 200 && res.data) {
            this.setData({
              "items.collectFlag": !items.collectFlag
            })
          }
        })
      }
    },
    onclickBuynow(e) {
      let { btnType } = this.data.datas.componentData;
      let _this = this;
      let {
        minProductGoodsMixid,
        minProductGoodsId,
        productName,
        minGoodsId,
        shopName
      } = this.data.items;
      let linkVal = "";
      if (btnType < 6) {
        // 加入购物车
        console.log("加入购物车");
        // $themeAddToCard(this.data.items);
        console.log(app.globalData.shopInfo.whetherOpenEnterprisesWantGoods - 0,'app.globalData.shopInfo=')
        let { whetherToEnableQuickPurchase } = app.shop_configuration;
        if (whetherToEnableQuickPurchase == 1) {
          // 快速加购
          $themeAddToCard(this.data.items);
        } else {
          // 选规格加购
          if (app.globalData.shopInfo.whetherOpenEnterprisesWantGoods - 0 == 1) {
            // 开启企业要货加购
            app.openTwoBAddCart(_this.data.items);
          } else {
            app.openSelectGoods(_this.data.items);
          }
        }
      } else {
        // 进入确认订单
        linkVal = `/order/orderConfirm?productGoodsMixId=${minProductGoodsMixid}&productGoodsId=${minProductGoodsId}&goodsId=${minGoodsId}&qty=1&goodsString=null&source=3`;
      }
      console.log(linkVal, "-------90");
      app.trackCpn(e, this.data.datas.componentName, {
        shopName,minGoodsId,productName,minProductGoodsId,minProductGoodsMixid
      })
      $themeToLink({ type: 1, link: linkVal });
    },
    toMerchants(e) {
      let { orgId } = this.data.items;
      app.trackCpn(e, this.data.datas.componentName, 'toMerchants')
       $themeToLink({ type: 1, link: `/merchantsDetail/${orgId}` });

    },
    errorFunction(e) {
      this.setData({
        "items.productImgUrl":"https://cdn.mayi888.com/product/85pdScJ5ch.jpg?x-oss-process=image/resize,m_pad,limit_0,w_400,h_400",
        "items.coverImage":"https://cdn.mayi888.com/product/85pdScJ5ch.jpg?x-oss-process=image/resize,m_pad,limit_0,w_400,h_400",
      })
    },
  },
  // 组件生命周期
  lifetimes: {
    created() {},
    attached() {
      this.init();
    },
    ready() {},
    moved() {},
    detached() {}
  },
  definitionFilter() {},
  // 页面生命周期
  pageLifetimes: {
    // 页面被展示
    show() {
      const { isPageHidden } = this.data;

      // show事件发生前，页面不是处于隐藏状态时
      if (!isPageHidden) {
        return;
      }

      // 重新执行定时器等操作
    },
    // 页面被隐藏
    hide() {
      this.setData({
        isPageHidden: true
      });

      // 清除定时器等操作
    },
    // 页面尺寸变化时
    resize() {}
  }
};

Component(componentOptions)
