const app = getApp();
const { $themeToLink } = app;
const componentOptions = {
  // 组件选项
  options: {
    multipleSlots: true
  },
  behaviors: [],
  properties: {
    datas: {
      type: Object
    },
    countDownShow: {
      type: Boolean
    },
    num: {
      type: Number
    }
  },
  // 组件数据
  data: {
    isPageHidden: false, // 页面是否处于隐藏状态
    // hideItem: false,
    timeData: {}
  },
  // 数据监听器
  observers: {},
  // 组件方法
  methods: {
    init() {},
    onChange(e) {
      let { isStart, startTime } = this.data.datas;
      isStart =
        new Date(startTime.replace(/-/g, "/")).getTime() > new Date().getTime()
          ? true
          : false;
      this.setData({ timeData: e.detail, "datas.isStart": isStart });
    },
    toActivity(e) {
      app.trackCpn(e, this.data.datas.componentName)
      $themeToLink({ type: 1, link: `/brandTopics/${this.data.datas.id}` });
    }
  },
  // 组件生命周期
  lifetimes: {
    created() {},
    attached() {
      this.init();
    },
    ready() {},
    moved() {},
    detached() {}
  },
  definitionFilter() {},
  // 页面生命周期
  pageLifetimes: {
    // 页面被展示
    show() {
      const { isPageHidden } = this.data;

      // show事件发生前，页面不是处于隐藏状态时
      if (!isPageHidden) {
        return;
      }

      // 重新执行定时器等操作
    },
    // 页面被隐藏
    hide() {
      this.setData({
        isPageHidden: true
      });

      // 清除定时器等操作
    },
    // 页面尺寸变化时
    resize() {}
  }
};

Component(componentOptions)
