// static/nativeComponents/module/SkeletonBlock/index.js
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    type: {
      type: String,
      default: "row",
    },
    // 渲染块行数
    row: {
      type: Number,
      default: 4,
    },
    // 列数
    col: {
      type: Number,
      default: 1,
    },
    // 模块高度
    height: {
      type: Number,
      default: 30,
    },
  },

  

  /**
   * 组件的初始数据
   */
  data: {
    blockNumber : 0,
    SkeletonItemWidth : 0
  },

  ready() {
    if (this.data.type == 'flow'){
      this.setData({
        blockNumber : 4
      })
    }else{
      this.setData({
        blockNumber: this.properties.row * this.properties.col
      })
    }

    this.setData({
      SkeletonItemWidth: this.data.type == 'row' ? '100%' :'48%'
    })

  },

  /**
   * 组件的方法列表
   */
  methods: {

  }
})
