
class fenxiaoModel{
    fenxiaoApi = {
        query_login_spoken: null,//查询分销信息
        becomepokesmanCustomer: null,//绑定商上级分销关系
        saveCustomerInviterInviteeRel: null,//绑定商上级客户关系
        getHomePageQuickAccess: null,//查询个人名片入口
        query_isEntry: null,//查询成为分销弹框
        getDistributorHomepage: null,//查询是否有自己的小店
        getDistributorHomepageGoodsList: null,//首页分销商货架信息
        getSpokesmanidByShare: null,//获取分销分享信息
        oneClickShopQuickCopy: null,//一键开店快速复制
        apply_for_withdraw: null,//关闭分销弹框
    }
    spokesmanInfo = null;//分销信息
    applySucessEntry = {};//分销弹框信息
    spokesmanidByShareInfo = null;//获取分享信息
    distributorHomepageInfo = null;//小店详情
    constructor({
        query_login_spoken,
        becomepokesmanCustomer,
        saveCustomerInviterInviteeRel,
        getHomePageQuickAccess,
        query_isEntry,
        getDistributorHomepage,
        getDistributorHomepageGoodsList,
        getSpokesmanidByShare,
        oneClickShopQuickCopy,
        apply_for_withdraw,
    }){
        this.fenxiaoApi.query_login_spoken = query_login_spoken;
        this.fenxiaoApi.becomepokesmanCustomer = becomepokesmanCustomer;
        this.fenxiaoApi.saveCustomerInviterInviteeRel = saveCustomerInviterInviteeRel;
        this.fenxiaoApi.getHomePageQuickAccess = getHomePageQuickAccess;
        this.fenxiaoApi.query_isEntry = query_isEntry;
        this.fenxiaoApi.getDistributorHomepage = getDistributorHomepage;
        this.fenxiaoApi.getDistributorHomepageGoodsList = getDistributorHomepageGoodsList;
        this.fenxiaoApi.getSpokesmanidByShare = getSpokesmanidByShare;
        this.fenxiaoApi.oneClickShopQuickCopy = oneClickShopQuickCopy;
        this.fenxiaoApi.apply_for_withdraw = apply_for_withdraw;
    }
    //获取分销信息
    getSpokesmanInfo(replace = false){
        let _this = this
        return new Promise(function (resolve, reject) {
            if(_this.spokesmanInfo&&!replace) {
                resolve(_this.spokesmanInfo)
            }else {
                _this.setSpokesmanInfo().then(res=>{
                    resolve(res)
                }).catch(res=>{
                    reject(res)
                })
            }
        });
    }
    //设置分销信息
    setSpokesmanInfo() {
        let _this = this
        return new Promise(function (resolve, reject) {
            _this.fenxiaoApi.query_login_spoken().then(res=>{
                if(res.data.code == '200') {
                    _this.spokesmanInfo = res.data.data;
                    resolve(res.data.data) 
                }else {
                    reject(res)  
                }
            });
        });
    }
    //绑定分销关系
    becomeRelation(extConfig) {
        let _this = this
        return new Promise(function (resolve, reject) {
            if(extConfig&&extConfig.spokesmanRelId) {
                _this.fenxiaoApi.becomepokesmanCustomer(extConfig.spokesmanRelId).then(res=>{
                    if(res.data.code == '200') {
                        resolve(res)
                    }else {
                        reject(res)
                    }
                })
            }else if(extConfig&&extConfig.userId) {
                _this.fenxiaoApi.saveCustomerInviterInviteeRel(extConfig.userId).then(res=>{
                    if(res.data.code == '200') {
                        resolve(res)
                    }else {
                        reject(res)
                    }
                })
            }else {
                resolve(false)
            }
        })
    }
    //查询个人名片入口
    getHomePageQuickAccess() {
        let _this = this
        return new Promise(function (resolve, reject) {
            _this.fenxiaoApi.getHomePageQuickAccess().then(res=>{
                if(res.data.code == '200' && res.data.data == 'true') {
                    resolve(true)
                }else {
                    reject(false)
                }
            })
        })
    }
    //查询是否有自己的小店
    getDistributorHomepage(spokesmanInfo,replace=false) {
        let _this = this
        return new Promise(function (resolve, reject) {
            if(_this.distributorHomepageInfo&&!replace) {
                resolve(_this.distributorHomepageInfo)
            }else {
                _this.fenxiaoApi.getDistributorHomepage(spokesmanInfo.id).then(res=>{
                    if (
                        res.data.code == "200" &&
                        res.data.data &&
                        res.data.data != "null" &&
                        res.data.data != "false"
                    ) {
                        _this.distributorHomepageInfo = res.data.data
                        resolve(res.data.data)
                    }
                })
            }
        })
    }
    //查询成为分销弹框
    query_isEntry() {
        let _this = this
        return new Promise(function (resolve, reject) {
            _this.fenxiaoApi.query_isEntry().then(res=>{
                if (
                    res.data.code == "200" &&
                    res.data.data &&
                    res.data.data != "null" &&
                    res.data.data != "false"
                ) {
                    _this.applySucessEntry = res.data.data;
                    resolve(res.data.data)
                }else{
                    reject(res)
                }
            })
        })
    }
    //查询分销商货架
    getDistributorHomepageGoodsList(data) {
        let _this = this
        return new Promise(function (resolve, reject) {
            _this.fenxiaoApi.getDistributorHomepageGoodsList(data).then(res=>{
                if(res.data.code == '200') {
                    resolve(res.data.data)
                }else {
                    reject(res)
                }
            })
        })
    }
    //获取分享信息
    getSpokesmanidByShare(replace=false) {//replace是否更新数据
        let _this = this
        return new Promise(function (resolve, reject) {
            if(_this.spokesmanidByShareInfo&&!replace) {
                resolve(_this.spokesmanidByShareInfo)
            }else {
                _this.fenxiaoApi.getSpokesmanidByShare().then(res=>{
                    if(res.data.code == '200') {
                        _this.spokesmanidByShareInfo = res.data.data;
                        resolve(res.data.data)
                    }else {
                        reject(res)
                    }
                })
            }
        })
    }
    //一键复制店铺
    oneClickShopQuickCopy(data) {
        let _this = this
        return new Promise(function (resolve, reject) {
            _this.fenxiaoApi.oneClickShopQuickCopy(data).then(res=>{
                if(res.data.code == '200') {
                    resolve(res.data.data)
                }else {
                    reject(res)
                }
            })
        })
    }
    //关闭分销成功弹框
    apply_for_withdraw(data) {
        let _this = this
        return new Promise(function (resolve, reject) {
            _this.fenxiaoApi.apply_for_withdraw(data).then(res=>{
                if(res.data.code == '200') {
                    resolve(res.data.data)
                }else {
                    reject(res)
                }
            })
        })
    }
}
export default fenxiaoModel