// static/nativeComponents/SharePicture/index.js
const app = getApp()
const { indexApi } = app;
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    datas: {
      type: Object
    }
  },

  /**
   * 组件的初始数据
   */
  data: {
    tabIndex : 0,
    waterfallLeftList:[],
    waterfallRightList:[],
    loaded : true,
    pageNum : 1,
    tabId : 1,
    iconStyleList: [
      {
        name: "common-iconqinziAPPtubiao-",
        value: 0,
        toggle: "common-icondianzan"
      },
      { name: "common-iconaixin1", value: 1, toggle: "common-iconaixin" }
    ],
    praiseState : false,
    getListFinish : false
  },
  ready(){
    this.queryBuyingShowList(0);
  },

  /**
   * 组件的方法列表
   */
  methods: {
    tabHandle(e){
      let index = e.currentTarget.dataset.index
      let item = e.currentTarget.dataset.item
      console.log(index, item, this.data.tabIndex)
      if(this.data.tabIndex != index){
        this.setData({
          tabIndex: index,
          tabId: item.id,
          getListFinish :false
        })
        this.queryBuyingShowList(0)
      }
     
    },
    queryBuyingShowList(type){
      if (this.data.datas.componentData["activityFlag"][0]["id"] == "" || !this.data.loaded){

        return;
      }
      this.setData({
        loaded : false
      })
      if(type == 0){
        this.setData({
          pageNum : 1
        })
      }else{
        this.setData({
          pageNum : this.data.pageNum + 1
        })
      }
      let query = {
        activityId: this.data.datas.componentData.activityFlag[0].id || 4,
        sortType: this.data.tabId,
        pageNum: this.data.pageNum,
        startTime: Array.isArray(this.data.datas.componentData.publishTime)
          ? this.data.datas.componentData.publishTime[0]
          : "",
        endTime: Array.isArray(this.data.datas.componentData.publishTime)
          ? this.data.datas.componentData.publishTime[1]
          : "",
        pageSize: +this.data.datas.componentData["quantity"]
      }

      indexApi.queryBuyingShowList(query).then(res => {
        this.setData({
          loaded :true
        })
        if(res.data.code == '200'){
          let data = res.data.data

          if(res.data.pages <= res.data.current){
            this.setData({
              getListFinish : true
            })
          }
          if(type == 0){

            this.setData({
              waterfallLeftList : [],
              waterfallRightList:[]
            })

            let { waterfallLeftList, waterfallRightList } = this.data

            data.forEach((item,index) => {
              item.customerHandImage = app.DFSImg(item.customerHandImage)
              item.checkMP4Status = this.checkMP4(item.urls)
              item.custname = this.clientInfoName(item)
              if (item.praiseFlag == 'false'){
                item.nameIcon = this.data.iconStyleList[this.data.datas.componentData['iconStyle']].name
              }else{
                item.nameIcon = this.data.iconStyleList[this.data.datas.componentData['iconStyle']].toggle
              }
              
              if (this.getFileType(item.urls[0]) == 'video'){
                item.coverImg = app.DFSImg(`${item.urls[0]}?x-oss-process=video/snapshot,t_1,m_fast`)
              }else{
                item.coverImg = app.DFSImg(item.urls[0], 400, null, 1)
              }

              if(index % 2 == 0){
                waterfallLeftList.push(item)
              }else{
                waterfallRightList.push(item)
              }
            })

            this.setData({
              waterfallLeftList,
              waterfallRightList
            })

            console.log(this.data.waterfallLeftList, this.data.waterfallRightList,' this.data.waterfallRightList')
          }else{
            
            let { waterfallLeftList, waterfallRightList } = this.data
            data.forEach((item, index) => {
              item.customerHandImage = app.DFSImg(item.customerHandImage)
              item.checkMP4Status = this.checkMP4(item.urls)
              item.custname = this.clientInfoName(item)
              if (item.praiseFlag == 'false') {
                item.nameIcon = this.data.iconStyleList[this.data.datas.componentData['iconStyle']].name
              } else {
                item.nameIcon = this.data.iconStyleList[this.data.datas.componentData['iconStyle']].toggle
              }

              if (this.getFileType(item.urls[0]) == 'video') {
                item.coverImg = app.DFSImg(`${item.urls[0]}?x-oss-process=video/snapshot,t_1,m_fast`)
              } else {
                item.coverImg = app.DFSImg(item.urls[0], 400, null, 1)
              }

              if (index % 2 == 0) {
                waterfallLeftList.push(item)
              } else {
                waterfallRightList.push(item)
              }
            })

            this.setData({
              waterfallLeftList,
              waterfallRightList
            })

          }
        }
      })
      .catch(err => {
        this.setData({
          loaded: true
        })
      })


    },
    getFileType(name) {
      if (!name) return false;
      var imgType = ["gif", "jpeg", "jpg", "bmp", "png"];
      var videoType = [
        "avi",
        "wmv",
        "mkv",
        "mp4",
        "mov",
        "rm",
        "3gp",
        "flv",
        "mpg",
        "rmvb"
      ];
      if (
        RegExp(".(" + imgType.join("|") + ")$", "i").test(name.toLowerCase())
      ) {
        return "image";
      } else if (
        RegExp(".(" + videoType.join("|") + ")$", "i").test(name.toLowerCase())
      ) {
        return "video";
      } else {
        return false;
      }
    },
    checkMP4(data) {
      for (let index = 0; index < data.length; index++) {
        if (this.getFileType(data[index]) == "video") {
          return true;
        } else {
          return false;
        }
      }
    },
    clientInfoName(item){
      if (item.customerName.length > 0 || item.customerNickname.length > 0) {
        if (this.data.datas.componentData["clientInfoEncryption"]) {
          return this.noPassByName(item.customerName || item.customerNickname);
        } else {
          return item.customerName || item.customerNickname;
        }
      } else {
        if (this.data.datas.componentData["clientInfoEncryption"]) {
          return "****";
        } else {
          return "匿名用户";
        }
      }
    },
    noPassByName(str) {
      if (null != str && str != undefined) {
        if (str.length <= 3) {
          return str.substring(0, 1) + "****";
        } else {
          return `${str.substr(0, 1)}****${str.charAt(str.length - 1)}`;
        }
      } else {
        return "****";
      }
    },
    addBuyingShowPraise(e){
      let item = e.currentTarget.dataset.item
      let index = e.currentTarget.dataset.index
      let type = e.currentTarget.dataset.type

      let list = type == 'left' ? 'waterfallLeftList' : 'waterfallRightList'
      if (this.data.praiseState) return;
      this.setData({
        praiseState : true
      })
      let query = {
        buyingShowId: item.id
      };
      indexApi.addBuyingShowPraise(query).then(res => {
        this.setData({
          praiseState : false
        })
        if(res.data.code == '200'){
          if(res.data.data == 'true'){
            let praiseFlag = `${list}[${index}].praiseFlag`
            let praisePoints = `${list}[${index}].praisePoints`
            this.setData({
              [praiseFlag] : 'true',
              [praisePoints]: Number(this.data[list][index].praisePoints )+ 1
            })

          }else if(res.data.data == 'false'){

            let praiseFlag = `${list}[${index}].praiseFlag`
            let praisePoints = `${list}[${index}].praisePoints`
            this.setData({
              [praiseFlag]: 'false',
              [praisePoints]: Number(this.data[list][index].praisePoints) - 1
            })

          }
        }
      })
      .catch(err => {
        this.setData({
          praiseState: false
        })
      })

    },
    buyingShowHandle(e){
      let id = e.currentTarget.dataset.id
      console.log(id)
      app.$themeToLink({
        type: 1,
        link: '/buyerShow/showDetail?buyingShowId=' + id
      })
    },
    viewMore(){
      this.queryBuyingShowList(1);
    }
  }
})
