const app = getApp();
Component({
  properties: {
    selected: {
      type: Number,
      default: -1
    }
  },
  data: {
    // selected: -1,
    color: "#7A7E83",
    selectedColor: "#3cc51f",
    list: [
    ],
    mid: '',
    componentData: {},
    show: true,
    mainColor: "",
    showFlag: "up",
    cartNum: 0
  },
  attached() {
    this.init()
  },
  methods: {
    init() {
      if (app.themeColor["--main-color"] != "#ffffff") {
        this.setData({
          mainColor: app.themeColor["--main-color"]
        });
      } else {
        app.themeColorCallBack = res => {
          this.setData({
            mainColor: res["--main-color"]
          });
        };
      }
      // 
      let that = this;
      if (app.globalData.footerVal) {
        let mid = Math.ceil(app.globalData.footerVal.componentData.list.length / 2 - 1)

        app.globalData.footerVal.componentData.list.forEach(item => {
          item.isAntt = item.icon.includes('ant-')
          console.log('isAntt', item.isAntt)
        })
        console.log(app.globalData.footerVal.componentData.list,'app.globalData.footerVal.componentData.list')
        that.setData({
          componentData: app.globalData.footerVal.componentData,
          list: app.globalData.footerVal.componentData.list,
          mid: mid
        });
      } else {
        app.footerCallBack = function (params) {
          params.componentData.selectIconColor = app.globalData.footerVal.componentData.selectIconBackground == 1 ? 'val(--main-color)' : params.componentData.selectIconColor
          let mid = Math.ceil(params.componentData.list.length / 2 - 1)
          
          params.componentData.list.forEach(item => {
            item.isAntt = item.icon.includes('ant-')
            console.log('isAntt', item.isAntt)
          })

          console.log(params.componentData.list,'app.globalData.footerVal.componentData.list')



          that.setData({
            componentData: params.componentData,
            list: params.componentData.list,
            mid: mid
          });
        };
      }
    },
    switchTab(e) {
      const { index } = e.currentTarget.dataset;
      if (index == this.data.selected) return
      app.$themeToLink(this.data.list[index]["link"], 1);
    }
  }
});
