import store from '../store/index'
let shopMixid = process.env.SHOP_MIXID;
// wx.getStore
export async function requestGET(url, options) {

    return new Promise((resolve, reject) => {
        wx.request({
            url: url,
            data: options,
            method: "GET",
            header: {
                "Shop-Mixid": shopMixid,
                "Offline-Shop-Code": store.state.offlineShopCode,
                "Authorization": wx.getStorageSync('sessionid') || "",
                // "dubbo-tag": "ljx"
            },
            success: function (res) {
                resolve(res)
            },
            fail: function (res) {
                reject(res)
            }
        })
    })
}

export async function requestPOST(url, options) {
    return new Promise((resolve, reject) => {
        wx.request({
            url: url,
            data: options,
            method: "POST",
            header: {
                "Shop-Mixid": shopMixid,
                "Authorization": wx.getStorageSync('sessionid') || "",
                "Offline-Shop-Code": store.state.offlineShopCode,
                // "dubbo-tag": "ljx"
            },
            success: function (res) {
                resolve(res)
            },
            fail: function (res) {
                reject(res)
            }
        })
    })
}

export function requestPOST1(url, options) {
    return new Promise((resolve, reject) => {
        wx.request({
            url: url,
            data: options,
            method: "POST",
            header: {
                "Content-Type": "application/x-www-form-urlencoded",
                "Shop-Mixid": shopMixid,
                Authorization: wx.getStorageSync('sessionid') || "",
                "Offline-Shop-Code": store.state.offlineShopCode,
                // "dubbo-tag": "ljx"
            },
            success: function (res) {
                resolve(res)
            },
            fail: function (res) {
                reject(res)
            }
        })
    })
}

// function getHeader() {
//     let sessionid = wx.getStorageSync('sessionid');
//     let header = {
//         "Content-Type": "application/x-www-form-urlencoded",
//         "Shop-Mixid": shopMixid,
//         Authorization: sessionid
//     };
//     // if (!sessionid) {
//     //     delete header.Authorization
//     // }
//     return header
// }