import cart from "@/api/cart"
import shop from "@/api/shop"
import coupon from "@/api/coupon";
import classificationApi from "@/api/classification";
// 登录白名单 name
export const noLoginList = ["index", "media-video", "goods-goodsInfo", "goods-commodityMenu", "goodsSearch-goodsSearch", "contentSearch-contentSearch", "chooseStores", "activty-receivingGift", "activty", "login-register", "login-phoneLogin", "login-authInformation", "login-forgetPassWord", "login-accountLogin", "login-wxRegister", "pay-payList", "comment-evaluateList", "goods-commonProblemList", "article-articlePage", "article-articleList", "goods-posters", "liveBroadcast", "liveBroadcast-list", "personalCenter-coupon-getCoupon", "buyerShow-showDetail", "goods-addGoodsList", "personalCenter-CDkey-exchange", "giftCards-linkReceive", "giftCoupon-preview", "smartForm", "shopCart-shareShopCart", "groupBuying-beInvite", "brandTopics", "personalCenter-spokesmanCenter", "personalCenter-spokesmanCenter-mine-spokesmanHomePage", "liveBroadcast-lived", "personalCenter-spokesmanCenter-mine-getBusinessCard", "changeAdr"];
// path
export const noLoginListPath = noLoginList.map(item => {
    item = item.replace(/-/g, '/')
    item = '/' + item
    item == "/index" && (item = "/")
    return item
})
// 有底部栏页面
export const containFooterPage = ["/", "/goods/commodityMenu", "/shopCart/shoppingCart", "/personalCenter"]
// 主题色
export let themeColor = {
    "--main-color": "#ffffff",
    "--minor-color": "#ffffff"
}

// 获取link 中页面地址(link兼容 有object或者string)
export function getUrlofLink(data) {
    return data.link.split('?')[0]
}
export function getUrlofQuery(data) {
    return data.link.split('?')[1] || ''
}
// 全局跳转  data:link数据    option:是否为底部栏触发
export function $themeToLink(data, option) {
   
    // console.log(currentPage,'currentPage',getUrlofLink(data))
    // if(getUrlofLink(data).includes(currentPage)) return

    // 
    let app = getApp();
    let type = data.type;
    // 登录拦截和底部导航栏拦截（非功能项）
    if (type != 2) {
        // 登录拦截
        let parseLink = getUrlofLink(data);
        let parseQuery = getUrlofQuery(data);

        let noLogin = noLoginListPath.includes(parseLink) || parseLink.substr(0, 7) == "/goods/" || parseLink.includes('/brandTopics');
        if (!noLogin && !wx.getStorageSync("sessionid")) {
            let url = `/pages/login/main?back=${parseLink}`;
            wx.navigateTo({ url });
            return
        }
        //判断是否市跳转到tabbar页面 替换首页位置 
        let isTabbarIndex = checkTabbarPage(parseLink);
        if (isTabbarIndex >= 0) {
            // 无底部栏h5页面
            // if (!containFooterPage.includes(parseLink)) {
            //     toPage(getUrlofLink(data), getUrlofQuery(data))
            //     return
            // }


            isTabbarIndex = isTabbarIndex == 0 ? checkTabbarPage('/') : isTabbarIndex;
            let url=parseLink == '/' ? `/pages/home/main` : `/pages/tabBar${isTabbarIndex}/main`;
            let routes = getCurrentPages();
            let currentPage = routes[routes.length - 1].route;
            if (currentPage==url) return

            let query=parseQuery?`?${parseQuery}`:'';
            wx.reLaunch({
                url:url+query
            })
            return
        }
    }


    // 历史数据
    if (type == undefined || type == 'undefined') {
        if (data.length > 0) {
            toPage(getUrlofLink(data), getUrlofQuery(data))
        }
        return
    }
    // -----------------
    if (type == 0) {//无链接
        return
    } else if (type == 1) {//h5页面
        //兼容
        if (data.link.substring(0, 1) == "/") {
            toPage(getUrlofLink(data), getUrlofQuery(data))
        } else {
            if (data.link.startsWith('http') || data.link.startsWith('https')) {
                wx.navigateTo({ url: '/pages/wxArticle/main?link=' + encodeURIComponent(data.link) });
            }
        }
    } else if (type == 1.1) {//小程序页面  可能增加登录态拦截
        wx.navigateTo({ url: data.link });
    } else if (type == 1.2) { //第三方链接
        if (data.link == 'outerChain:businessCenter') {
            // 进入商家中心外链
            let url = `${config.GUIDE_URL}/login?mixid=${this.$nuxt.$route.query.mixid}&back=${encodeURIComponent(window.location.href)}`;
            wx.navigateTo({ url: '/pages/wxArticle/main?link=' + encodeURIComponent(url) });
            return
        }
        if (data.link.substring(0, 1) == "/") {
            toPage(getUrlofLink(data), getUrlofQuery(data))
        } else {
            wx.navigateTo({ url: '/pages/wxArticle/main?link=' + encodeURIComponent(data.link) });
        }
    } else if (type == 2) {//功能
        let featureType = data.feature.type;
        if (featureType == 'themeCouponClick' || featureType == 0) {//优惠券
            // this.$themeCouponClick(data.feature.value.couponCode, data.feature.value);
        } else if (featureType == 1) {//分享
            console.log('是分享了。。。。');
            app.shareInit({ itemList: data.feature.value });
        } else if (featureType == "themeMemberCardClick" || featureType == 2) { //会员卡
            // this.$themeMemberCardClick(data.feature.value);
        }
    } else if (type == 3) { //小程序跳转到小程序
        wx.navigateTo({
            url: `/pages/toMini/main?weappPage=${encodeURIComponent(data.link)}&weappAppId=${data.name}`,
        })
    } else {
        //向后兼容
        if (data.length > 0) {
            toPage(getUrlofLink(data), getUrlofQuery(data))
        }
    }
}
export function $themeAddToCard(item, callback) {
    let errorMsg = "";
    if (item.productNature == 5) {
        errorMsg = "电子卡券不可加入购物车";
    }
    if (item.productNature == 3) {
        errorMsg = "会员卡不可加入购物车";
    }
    if (item.productNature == 2) {
        errorMsg = "虚拟商品不可加入购物车";
    }
    if (errorMsg) {
        wx.showToast({
            title: errorMsg,
            icon: 'none',
        });
    }
    cart
        .addCart([
            { productGoodsId: item.minProductGoodsId, qty: item.saleQty }
        ])
        .then(res => {
            if (res.data.code == 200) {
                wx.showToast({ title: "加入购物车成功", icon: "none" });
            }
            callback();
        });
}

function toPage(backPath, backParams = "") {
    console.log(backPath, backParams,'--------------------------159');
    wx.navigateTo({
        url: `../index/main?from=themeLink&backpath=${encodeURIComponent(backPath)}&params=${encodeURIComponent(backParams)}`
    });
}

// check 链接是否为底部导航栏页面 返回索引
export function checkTabbarPage(link) {
    let app = getApp()
    if (!app.globalData.footerVal) return -1
    let footerVal = app.globalData.footerVal.componentData.list;
    let isFooter = footerVal.findIndex(item => {
        return getUrlofLink(item.link) == link.split('?')[0]
    })
    return isFooter
}

// 当前底部栏选中项
export function setTabBarActive(data) {
    // console.log(data,'sssssssssss',this.$mp.page.getTabBar(),data)
    if (data < 0 || !this.$mp.page) return
    if (typeof this.$mp.page.getTabBar === 'function' &&
        this.$mp.page.getTabBar()) {
        this.$mp.page.getTabBar().setData({
            selected: data
        })
    }
}


// 遍历所有组件有显示条件的id  是否包含地区导航组件
export function checkShowConditionIds(list) {
    let allCondition = [];
    let isAreaNavigation = false;
    list.forEach(element => {
        // 有地区导航组件
        if (element.componentCode == 'area-navigation') {
            isAreaNavigation = true
        }
        pollCondition(element)
    });
    function pollCondition(object) {
        if (Object.prototype.toString.call(object) === '[object Object]') {
            if (object.condition != '' && object.condition != undefined) {
                allCondition.push(object.condition);
            }
            for (const key in object) {
                if (object.hasOwnProperty(key)) {
                    const element = object[key];
                    if (Object.prototype.toString.call(element) === '[object Object]') {
                        if (element.condition != '' && element.condition != undefined) {
                            allCondition.push(element.condition);
                        }
                        pollCondition(element)
                    } else if (Object.prototype.toString.call(element) === '[object Array]' && element.length > 0) {
                        element.forEach((item) => {
                            pollCondition(item)
                        })
                    }
                }
            }
        }
    }
    return {
        allCondition: [...new Set(allCondition)],
        isAreaNavigation
    }
}
export function $themeArticleLike(item, callback) {
    let query = { articleId: item.id };
    classificationApi.addLike(query).then(res => {
        if (res.data.code == "200") {
            if (res.data.data == 'true') {
                callback("true");
            } else {
                callback("false");
            }
        } else {
        }
    });
}
export function getCoupon(code, item) {
    console.log("--------------------239");
    let usingIntegrals = (item.consumeIntegral - 0).toFixed(0);
    let couponCode = code;
    console.log(item, "------------------------242");
    if (item.receiveCostType == 1) {
        wx.showModal({
            confirmColor: "#CA173B",
            content: `是否消耗${usingIntegrals}积分领取`
            })
            .then(() => {
            useCoupon(2, couponCode, usingIntegrals);
            })
            .catch(() => {
            // on cancel
        });
        return;
    } else {
        useCoupon(1, couponCode, usingIntegrals);
    }
};
function useCoupon(val, couponCode, usingIntegrals) {
  coupon.receive_coupon(couponCode).then(res => {
    console.log(res, "cou137");
    if (res.data.data == "true") {
      if (val == 1) {
        wx.showToast({ title: "领取成功", icon: "success" });
      } else {
        let tit = "积分-" + usingIntegrals;
        wx.showToast({ title: tit, icon: "success" });
      }
      // item.receive=false;
    } else {
      wx.showToast({title:res.data.msg ,icon :"none"});
      // item.receive=true;
    }
  });
};
export function themeMemberCardClick (item) {
    let query = {
        portalCardId: item.id
    };
    shop.getV3CardList(query).then(res => {
        console.log(res,'--------------------282')
        if (res.data.code == 200) {
            let cardData = "";
            res.data.data.forEach(innerItem => {
            if (innerItem.id == item.id) {
                cardData = innerItem;
            }
        });
        if (cardData.receiveWay == 0) {
            // 无门槛
            let cardId = cardData.id;
            let userInfo = wx.getStorageSync("userInfo") ? JSON.parse(wx.getStorageSync("userInfo")) : "";
        shop.drawV3Card(cardId).then(res => {
          if (res.data.code == 200) {
            wx.showToast({
              title: `开通【${cardData.title}】成功`,
              icon: "none"
            });
          } else {
              if (res.data.msg == "不能重复领卡") {
                  console.log("---------------------------to-----1")
                  let backParams = `&cardId=${cardData.id}&userTel=${userInfo.mobilephone}`;
                  toPage("/personalCenter/membershipCard",backParams);
                } else {
                    wx.showToast({ title: res.data.msg, icon: "none" });
                }
            }
        });
    } else if (cardData.receiveWay == 1) {
        // 自动领取
        console.log("自动领取");
    } else if (cardData.receiveWay == 2) {
        // 付费购买
        if (cardData.receiveStatus == 0) {
            console.log("---------------------------to-----2")
            let backParams = `&cardId=${cardData.id}`;
            toPage("/pay/payCard", backParams);
        } else {
            console.log("---------------------------to-----3")
            let backParams = `&cardId=${cardData.id}&userTel=${userInfo.mobilephone}`;
            toPage("/personalCenter/membershipCard", backParams);
        }
      } else {
        console.error("无效的领取方式");
      }
    } else {
      wx.showToast({title:res.data.msg,icon:"none"});
    }
  });
};