// static/nativeComponents/AreaNavigation/index.js
const app = getApp()
const { indexApi } = app;
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    datas : {
      type : Object
    },
    changeLocation:{
      type : String
    }
  },

  /**
   * 组件的初始数据
   */
  data: {
    noShow : false,
    positionCity: "",
    changeShow: false,
    positionName: '定位中',
    wxReady: false,
    designateAreaObj : null,
    showSpokesManHome: false,
  },
  ready(){
    console.log('++++++++++++++++++++定位组件加载好了++++++++++++++++++++')
    console.log(this.data.changeLocation,'changeLocation')
    console.log(getCurrentPages())


    

    this.setData({
      designateAreaObj: this.data.datas.componentData.designateAreaObj
    })
    //分销商货架存在
    if(
      app.fenxiaoModel.spokesmanInfo&&
      app.fenxiaoModel.spokesmanInfo.parentSpokesmanDistributionModel == '1'&& 
      app.fenxiaoModel.spokesmanInfo.distributorHomepage.id
    ) {
      this.setData({
        showSpokesManHome: true
      })
    }else {
      this.setData({
        showSpokesManHome: false
      })
    }
    console.log(this.data.datas.componentData.designateAreaObj,'2222')

    if (!wx.getStorageSync('location')) {
      wx.navigateTo({
        url: `/pages/changeAdr/main?areaGroupId=${this.data.datas.componentData.designateAreaObj.areaGroupId}&noLocation=1`
      })
      return
    }
    
    if (this.data.datas.componentInfo.visible == 1) {
      let _this = this;

      if (wx.getStorageSync('location')) {
        this.setData({
          'designateAreaObj.id': JSON.parse(wx.getStorageSync('location')).id,
          'designateAreaObj.regionName': JSON.parse(wx.getStorageSync('location')).regionName,
          'designateAreaObj.regionType': JSON.parse(wx.getStorageSync('location')).regionType,
          'designateAreaObj.systemRegionId': JSON.parse(wx.getStorageSync('location')).systemRegionId,
          'designateAreaObj.outId': JSON.parse(wx.getStorageSync('location')).outId,
          'designateAreaObj.areaGroupId': JSON.parse(wx.getStorageSync('location')).areaGroupId,
        })

        this.setData({
          positionName: this.data.designateAreaObj.regionName
        })
      }

      console.log('组件1', this.data.designateAreaObj)


      if(this.data.changeLocation == 1){
        return
      }
      
      wx.getLocation({
        type: 'wgs84',
        success(res) {
          console.log('组件1111', _this.data.designateAreaObj)
          console.log(res, '++++++++++获取地区')
          const latitude = res.latitude
          const longitude = res.longitude
          console.log('组件2', _this.data.designateAreaObj)
          indexApi.queryLocation(longitude, latitude).then(data => {
            if (data.data.code == '200') {
              let city = ''
              data.data.data.forEach(item => {
                if (item.operatingAreaAreaId) {
                  city = item;
                }
              })
              if (city == '') {
                _this.setData({
                  positionCity: data.data.data[0]
                })
              } else {
                _this.setData({
                  positionCity: city
                })
              }

              if(!wx.getStorageSync('location')){
                _this.setData({
                  'designateAreaObj.id': _this.data.positionCity.operatingAreaAreaId,
                  'designateAreaObj.regionName': _this.data.positionCity.regionName,
                  'designateAreaObj.regionType': _this.data.positionCity.regionType,
                  'designateAreaObj.systemRegionId': _this.data.positionCity.systemRegionId,
                  'designateAreaObj.outId': _this.data.positionCity.outId,
                })
              }


              console.log(_this.data.positionCity, '定位城市信息')
              console.log(_this.data.designateAreaObj, '组件信息')
              let str = JSON.stringify({
                id: _this.data.positionCity.operatingAreaAreaId,
                regionName: _this.data.positionCity.regionName,
                regionType: _this.data.positionCity.regionType,
                systemRegionId: _this.data.positionCity.systemRegionId,
                outId: _this.data.positionCity.outId,
                areaGroupId: _this.data.designateAreaObj.areaGroupId,
              })
              console.log(str, 'str.......')
              wx.setStorageSync('location', str)


              if (_this.data.positionCity.operatingAreaAreaId == _this.data.designateAreaObj.id) {
                _this.setData({
                  positionName: _this.data.positionCity.regionName
                })
              } else {
                  _this.setData({
                    changeShow: true
                  })               
              }



            } else {
              if (!wx.getStorageSync('location')) {
                if (_this.data.designateAreaObj.id) {

                  wx.setStorageSync('location', JSON.stringify({
                    id: _this.data.designateAreaObj.id,
                    regionName: _this.data.designateAreaObj.regionName,
                    regionType: _this.data.designateAreaObj.regionType,
                    systemRegionId: _this.data.designateAreaObj.systemRegionId,
                    areaGroupId: _this.data.designateAreaObj.areaGroupId,
                    outId: _this.data.designateAreaObj.outId
                  }))

                  _this.setData({
                    positionName: _this.data.designateAreaObj.regionName
                  })
                }
              }
            }
          }).catch(err => {
            console.log('定位')
            if (!wx.getStorageSync('location')) {
              if (_this.data.designateAreaObj.id) {

                wx.setStorageSync('location', JSON.stringify({
                  id: _this.data.designateAreaObj.id,
                  regionName: _this.data.designateAreaObj.regionName,
                  regionType: _this.data.designateAreaObj.regionType,
                  systemRegionId: _this.data.designateAreaObj.systemRegionId,
                  areaGroupId: _this.data.designateAreaObj.areaGroupId,
                  outId: _this.data.designateAreaObj.outId
                }))

                _this.setData({
                  positionName: _this.data.designateAreaObj.regionName
                })
              }
            }
          })
        },
        fail(error) {
          console.log('定位失败')
          if(!wx.getStorageSync('location')){
            if(_this.data.designateAreaObj.id){
              
              wx.setStorageSync('location', JSON.stringify({
                id : _this.data.designateAreaObj.id,
                regionName: _this.data.designateAreaObj.regionName,
                regionType: _this.data.designateAreaObj.regionType,
                systemRegionId : _this.data.designateAreaObj.systemRegionId,
                areaGroupId : _this.data.designateAreaObj.areaGroupId,
                outId : _this.data.designateAreaObj.outId
              }))

              _this.setData({
                positionName : _this.data.designateAreaObj.regionName
              })
            }
          }

        }
      })
    }


    console.log('111111++++++++++++++++++++定位组件加载好了++++++++++++++++++++111')
  },
  
  pageLifetimes : {
    show(){
      console.log('组件页面出来show', this.data.designateAreaObj)
      console.log('组件页面出来show', this.data.positionCity)

      if(wx.getStorageSync('location')){
        let locationObj = JSON.parse(wx.getStorageSync('location'))
        if (locationObj.id){
          if (locationObj.id != this.data.positionCity.operatingAreaAreaId){
            this.setData({
              positionName: locationObj.regionName
            })

            this.setData({
              'designateAreaObj.id': locationObj.id,
              'designateAreaObj.regionName': locationObj.regionName,
              'designateAreaObj.regionType': locationObj.regionType,
              'designateAreaObj.systemRegionId': locationObj.systemRegionId,
              '.designateAreaObj.areaGroupId': locationObj.areaGroupId,
              'designateAreaObj.outId': locationObj.outId
            })

            let obj = {
              operatingAreaAreaId: locationObj.id,
              regionName: locationObj.regionName,
              regionType: locationObj.regionType,
              systemRegionId: locationObj.systemRegionId,
              areaGroupId: locationObj.areaGroupId,
              outId: locationObj.outId,
            }

            this.setData({
              positionCity : obj
            })
          }
          // app.getThemePage({ mixid: "antgood", shopid: 67 })
          return
        }

        if (locationObj.regionName != this.data.positionCity.regionName){
          this.setData({
            positionName: locationObj.regionName
          })
          this.setData({
            'designateAreaObj.id': locationObj.id,
            'designateAreaObj.regionName': locationObj.regionName,
            'designateAreaObj.regionType': locationObj.regionType,
            'designateAreaObj.systemRegionId': locationObj.systemRegionId,
            'designateAreaObj.areaGroupId': locationObj.areaGroupId,
            'designateAreaObj.outId': locationObj.outId
          })
          let obj = {
            operatingAreaAreaId: locationObj.id,
            regionName: locationObj.regionName,
            regionType: locationObj.regionType,
            systemRegionId: locationObj.systemRegionId,
            areaGroupId: locationObj.areaGroupId,
            outId: locationObj.outId,
          }

          this.setData({
            positionCity: obj
          })
          // app.getThemePage({ mixid: "antgood", shopid: 67 })
          return
        }
      }
      

      
    }
  },


  /**
   * 组件的方法列表
   */
  methods: {
    //切换城市
    changeTo(){
      console.log(this.data.designateAreaObj)
      
      this.setData({
        'designateAreaObj.id': this.data.positionCity.operatingAreaAreaId,
        'designateAreaObj.regionName': this.data.positionCity.regionName,
        'designateAreaObj.regionType': this.data.positionCity.regionType,
        'designateAreaObj.systemRegionId': this.data.positionCity.systemRegionId,
        // 'designateAreaObj.areaGroupId': this.data.positionCity.areaGroupId,
        'designateAreaObj.outId': this.data.positionCity.outId
      })

      console.log(this.data.designateAreaObj)
      console.log(this.data.positionCity)
      let change = JSON.stringify(this.data.designateAreaObj)
      this.setData({
        positionName: this.data.positionCity.regionName,
        changeShow : false
      })
      wx.setStorageSync('location', change )

      wx.reLaunch({
        url: '/pages/home/main?changeLocation=1'
      })

    },
    continueBrowser(){
      console.log(this.data.designateAreaObj,'this.data.designateAreaObj')
      wx.setStorageSync('location', JSON.stringify(this.data.designateAreaObj))
      this.setData({
        positionName: this.data.designateAreaObj.regionName,
        changeShow: false
      })
      // wx.startPullDownRefresh()
      wx.reLaunch({
        url: '/pages/home/main?changeLocation=1'
      })

    },
    changeOtherCity(){
      console.log(getCurrentPages())
      wx.navigateTo({
        url: '/pages/changeAdr/main?areaGroupId=' + this.data.designateAreaObj.areaGroupId,
      })
    },
    toSearchPage(){
      app.$themeToLink({
        type : 1,
        link: '/goodsSearch/goodsSearch'
      })
    }
  },
  
})
