// static/nativeComponents/GoodsSearch/index.js
let app = getApp()
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    datas: {
      type: Object
    }
  },

  /**
   * 组件的初始数据
   */
  data: {
    backgroundColor : '',
    borderColor : '',
    placeholderValue : ''
  },
  ready(){
    this.setData({
      backgroundColor: this.data.datas.componentData["showStyle"] == 1 &&
        this.data.datas.componentData["backgroundColorShow"] ? this.data.datas.componentData["backgroundColor"] : "rgba(224, 224, 224, 0)",
    })

    if (this.data.datas.componentData["showStyle"] == 0){
      this.setData({
        borderColor : this.data.datas.componentData["borderColorShow"]
          ? this.data.datas.componentData["borderColor"]
          : "rgba(224, 224, 224, 0)"
      })
    }else{
      this.setData({
        borderColor: 'transparent'
      })
    }

    this.setData({
      placeholderValue: this.data.datas.componentData.placeHolderVal ? this.data.datas.componentData.placeHolderVal : '搜索店铺内'
    })
  },

  /**
   * 组件的方法列表
   */
  methods: {
    toSearchPage(){
      app.$themeToLink({
        type: 1,
        link: '/contentSearch/contentSearch?placeHolderText=' + (this.data.datas.componentData["placeHolderVal"] || '')
      })
    }
  }
})
