const app = getApp();
Component({
  properties: {
    selected: {
      type: Number,
      default: -1
    }
  },
  data: {
    // selected: -1,
    color: "#7A7E83",
    selectedColor: "#3cc51f",
    list: [
    ],
    mm: false,
    componentData: {},
    show: true,
    mmm: false,
    mainColor: "",
    showFlag: "up",
    cartNum: 0
  },
  ready() {
    if (app.themeColor["--main-color"] != "#ffffff") {
      this.setData({
        mainColor: app.themeColor["--main-color"]
      });
    } else {
      app.themeColorCallBack = res => {
        this.setData({
          mainColor: res["--main-color"]
        });
      };
    }
    // this.setData({
    //   mmm: Math.ceil(app.globalData.footerVal.componentData.list.length / 2 - 1)
    // });
  },
  attached() {
    this.init()
  },
  methods: {
    init() {
      let that = this;
      if (app.globalData.footerVal) {
        let mm =
          Math.ceil(app.globalData.footerVal.componentData.list.length / 2 - 1) ==
          that.data.selected &&
          app.globalData.footerVal.componentData["styleSelectionNum"] == 1;

        that.setData({
          componentData: app.globalData.footerVal.componentData,
          list: app.globalData.footerVal.componentData.list,
          mm: mm
        });
      } else {
        app.footerCallBack = function (params) {
          params.componentData.selectIconColor = app.globalData.footerVal.componentData.selectIconBackground == 1 ? 'val(--main-color)' : params.componentData.selectIconColor
          that.setData({
            componentData: params.componentData,
            list: params.componentData.list
            // mm:(Math.ceil(params.componentData.list.length/2-1)==that.data.selected&&params.componentData['styleSelectionNum']==1)
          });
          let mm =
            Math.ceil(params.componentData.list.length / 2 - 1) ==
            that.data.selected &&
            params.componentData["styleSelectionNum"] == 1;
        };
      }
      this.setData({
        mm:
          Math.ceil(this.data.list.length / 2 - 1) == this.data.selected &&
          this.data.componentData["styleSelectionNum"] == 1
      });
    },
    switchTab(e) {
      const { index } = e.currentTarget.dataset;
      if (index==this.data.selected) return
      app.$themeToLink(this.data.list[index]["link"], 1);
    }
  }
});
