import { requestPOST, requestGET, requestPOST1 } from "@/utils/request.js";

export default {
  // 查询直播详情
  getLiveInfo(options) {
    return requestPOST1(`${process.env.OLSHOP_URL}/liveBroadcastInfo/getLiveBroadcastInfoByIds?liveBroadcastId=${options}`);
  },
  // 查询商品详情
  getProductInfo(options) {
    return requestPOST1(`${process.env.OLSHOP_URL}/product/get_product_info?productId=${options}`);
  },
  // 查询商品详情（传productInfoId和 terminalProductId）
  getProductInfoTwo(options) {
    return requestPOST1(`${process.env.OLSHOP_URL}/product/get_product_info?productId=${options.productInfoId}&terminalProductId=${options.terminalProductId}`);
  },
  // 查询所有产品规格详情
  getProductGoodsByProductInfo(options) {
    return requestPOST1(`${process.env.OLSHOP_URL}/product/get_product_goods_by_product_info`, options);
  },
  // 获取商品所有规格
  getProductGoodsSpecifications(options) {
    return requestPOST1(`${process.env.OLSHOP_URL}/product/get_goods_specifications?productId=${options}`);
  },
  // 查询产品信息
  getProductGoodsByMixId(options) {
    return requestPOST1(`${process.env.OLSHOP_URL}/product/get_product_goods_by_mix_id?productGoodsMixId=${options}`);
  },
  // 添加购物车
  addCart(options) {
    return requestPOST(`${process.env.OLSHOP_URL}/cart/add_item`, options);
  },
  // 实时查询直播状态
  getLiveStateById(options) {
    return requestPOST(`${process.env.OLSHOP_URL}/liveBroadcastInfo/getLiveStateById`, options);
  },
  // 用户进入和退出直播间埋点接口
  userEntryOrExitsLiveRoom(options) {
    return requestPOST(`${process.env.OLSHOP_URL}/liveBroadcastInfo/userEntryOrExitsLiveRoom`, options);
  },
  // 提交直播评论
  addGuestbook(options) {
    return requestPOST(`${process.env.OLSHOP_URL}/liveBroadcastInfo/addGuestbook`, options);
  },
  // 直播间点赞接口
  addLiveLikeByUser(options) {
    return requestPOST(`${process.env.OLSHOP_URL}/liveBroadcastInfo/addLiveLikeByUser`, options);
  },
  // 直播中商品列表
  getListByLiveBroadcastId(options) {
    return requestGET(`${process.env.OLSHOP_URL}/liveBroadcastGoods/getListByLiveBroadcastId?id=${Number(options)}`);
  },
  // 单次直播数据统计接口
  getLiveStatisticsById(options) {
    return requestPOST(`${process.env.OLSHOP_URL}/liveBroadcastInfo/getLiveStatisticsById`,options);
  },
  // 商品点击埋点记录
  addLiveUserGoodsByUser(options) {
    return requestPOST(`${process.env.OLSHOP_URL}/liveBroadcastInfo/addLiveUserGoodsByUser`,options);
  },
  // 添加订阅和推送
  addLiveNoticeByCustomer(options) {
    return requestPOST(`${process.env.OLSHOP_URL}/broadcastReminderRecord/addLiveNoticeByCustomer`,options);
  },
  // 获取小程序码
  getLiveQRCode(options,data) {
    return requestGET(`${process.env.OLSHOP_URL}/liveBroadcastInfo/getLiveQRCode?id=${options}&kl=${data}`);
  },
  // 获取直播配置
  getConfigValueByConfigCode(options) {
    return requestPOST(`${process.env.OLSHOP_URL}/liveBroadcastInfo/getConfigValueByConfigCode`,options);
  },
  // 分享时记录
  addShareRecord(options) {
    return requestPOST(`${process.env.OLSHOP_URL}/liveBroadcastInfo/addShareRecord`,options);
  },
  //获取服务器时间戳
  queryServerTimeNow(){
    return requestGET(`${process.env.OLSHOP_URL}/liveBroadcastInfo/getServerTimeNow`)
  },
  // 获取个人资料
  getUserInfo() {
    let enterpriseAccountInfo = wx.getStorageSync("enterpriseAccount") ? JSON.parse(wx.getStorageSync("enterpriseAccount")) : "";
    let mainUserId = "";
    if (enterpriseAccountInfo) {
      mainUserId = enterpriseAccountInfo.customerId
    }
    return requestPOST(`${process.env.OLSHOP_URL}/user/get_user_info?mainUserId=${mainUserId}`)
  },
  imgToBase64(data){
    return requestPOST(`${process.env.OLSHOP_URL}/common/read_remote_file?url=${data}`)
  },
  //成为下级客户
  becomepokesmanCustomer(params) {
    return requestPOST(`${process.env.OLSHOP_URL}/spokesman/becomepokesmanCustomer/`+params+``, {})
  },
  //绑定上级关系
  saveCustomerInviterInviteeRel(params) {
    return requestPOST(`${process.env.OLSHOP_URL}/user/saveCustomerInviterInviteeRel/`+params+``, {})
  },
  //查看回放评论
  queryPlaybackComments(options){
    return requestPOST(`${process.env.OLSHOP_URL}/liveBroadcastInfo/getLiveGuestAndLikeNumById`,options);
  }
};
