const mutations = {
  setSpokesman(state, obj) {
    for (let [key, val] of Object.entries(obj)) {
      state[key] = val;
    }
  },
  setSpokesmanInfo(state, obj) {
    state.spokemanInfo = obj;
  },
  setSubscribeMessageObj(state, subscribeMessageObj) {
    state.subscribeMessageObj = subscribeMessageObj;
  },

  //设置登录状态
  setLoginStatus(state,val){
    wx.setStorage({
        key: "isLogin",
        data: val
    });
    state.isLogin = val;
  },
  // 设置商城登录用户信息
  setShopUserInfo(state, val) {
    state.shopUserInfo = val;
  },
  //设置用户信息
  setUserInfo(state,obj){
      wx.setStorage({
          key: "userInfo",
          data: JSON.stringify(obj)
      });
      state.userInfo = obj;
  },
  //退出登录
  logout(state){
      wx.clearStorage()
      state.isLogin = 0;
      state.userInfo = null;
  },
  setExtConfig(state,obj){
    state.mixid = obj
  },
  setExtConfigInfo(state,obj){
    state.extConfig = obj
  }

};
export default mutations