// static/nativeComponents/LiveBroadcast/index.js
let app = getApp()
const { indexApi } = app
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    datas: {
      type: Object
    }
  },

  /**
   * 组件的初始数据
   */
  data: {
    showNum : 0,
    showList : true,
  },
  ready(){
    if (this.data.datas.componentData.liveList.length >= this.data.datas.componentData.showNum) {
      this.setData({
        showNum: this.data.datas.componentData.showNum
      })
    } else {
      this.setData({
        showNum: this.data.datas.componentData.liveList.length
      })
    }



    this.init()
    console.log('datas.componentData.style', this.data.datas.componentData.liveList)
  },

  /**
   * 组件的方法列表
   */
  methods: {
    init(){
      this.setData({
        'datas.componentData.liveList' : []
      })
      console.log(this.data.datas.componentData.liveList, 'this.data.datas.componentData.liveList')

      indexApi.getLiveCon(this.data.datas.componentData.liveIdList).then(res => {
        if(res.data.code == '200'){
          if(res.data.data.length == 0){
            this.setData({
              showList : false,
              'datas.componentData.liveList' : [],
              'datas.componentData.liveIdList':[]
            })
          }else{
            res.data.data.forEach(item => {
              item.coverUrl = app.DFSImg(item.coverUrl);
              item.anchorHeadImages = app.DFSImg(item.anchorHeadImages);
              item.watchNum = item.watchNum ? (Number(item.watchNum) > 10000 ?( Number(item.watchNum)/10000).toFixed(1) + 'w' : item.watchNum ) : 0
            })
            this.setData({
              'datas.componentData.liveList' : res.data.data
            })
          }

          console.log(this.data.datas.componentData.liveList,'this.data.datas.componentData.liveList')
        }else{
          this.setData({
            showList : false
          })
        }
      })

    },
    toList(e){
      app.trackCpn(e, this.data.datas.componentName, '查看更多')
      app.$themeToLink({
        type: 1,
        link: '/liveBroadcast/list'
      })
    },
    toLiveDetail(e){
      let id = e.currentTarget.dataset.itemid
      app.trackCpn(e, this.data.datas.componentName, id)
      app.$themeToLink({
        type: 1,
        link: '/liveBroadcast/lived?liveId=' + id
      })
    }
  }
})
