// static/nativeComponents/PopUp/index.js
let app = getApp()
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    datas:{
      type:Object
    }
  },

  /**
   * 组件的初始数据
   */
  data: {
    timeout: null,
    domainShow: false,
    img : ''
  },
  detached(){
    clearTimeout(this.data.timeout);
  },

  ready() {
    let routes = getCurrentPages()
    let page = routes[routes.length - 1].route
    let userInfo =  wx.getStorageSync("loginUserInfo")
    console.log("用户信息",userInfo);
    let thisPageIsPushed = app.globalData[`${app.globalData.shopInfo.shopCode}_${page}_${this.data.datas.id}_thisPageIsPushed`]
    console.log("当前页面弹过",thisPageIsPushed);
    if(!thisPageIsPushed) {
      if(this.data.datas.componentData.pushPeople == '0') {
        this.init()
      }else if(this.data.datas.componentData.pushPeople == '1') {
        if(userInfo.tagInfoResponseDTOS) {
          let length = userInfo.tagInfoResponseDTOS.length
          for (let i = 0; i < length; i++) {
            if(this.data.datas.componentData.pushDesignee.includes(userInfo.tagInfoResponseDTOS[i].id)){
              this.init()
              break;
            }
          }
        }
      }
    }

  },

  /**
   * 组件的方法列表
   */
  methods: {
    init() {
      this.setData({
        img: app.DFSImg(this.data.datas.componentData.imageUrl,700,null,1)
      })
      console.log(this.data.datas.componentData,'this.data.datas.componentData.once')
      // if(!this.data.datas.componentData.once){
      //   console.log('laizhelile')
      //   let routes = getCurrentPages()
      //   let page = routes[routes.length - 1].route
      //   wx.removeStorageSync(`${app.globalData.shopInfo.shopCode}_popFlag_${page}_${this.data.datas.id}`)
      // }
      // if (this.getPopFlag() == 'true'){
      //   this.setData({
      //     domainShow : false
      //   })
      // }else{
      //   this.setData({
      //     domainShow: true
      //   })
      //   if (this.data.datas.componentData.columnNum > 0 && this.data.datas.componentData.autoOff){
      //     this.autoOff()
      //   }
      // }
      let nowTime = Date.now()
      let pushTime = this.data.datas.componentData.pushTime
      // 如果没有设置时间范围，按老客户的需求执行(30天后过期)，将条件设置为按天推送，间隔时间30天
      if(pushTime.length ==  0) {
          // if(this.datas.componentData.once){
          //   this.datas.componentData.pushFrequency = '0'
          // }else {
          //   // 每次进入推送
          //   this.datas.componentData.pushFrequency = '1'
          // } 暂时不兼容了
          this.isPush()
      }
      // 设置了时间范围，且在时间范围中，根据条件推送
      else if(pushTime.length > 0 && nowTime >= pushTime[0] && nowTime <= pushTime[1]) {
        this.isPush()
      }else {
        // 不在时间范围中，关闭
        this.setData({ domainShow: false })
      }
    },
    // 判断何时定时关闭
    autoOff() {
      let routes = getCurrentPages()
      let page = routes[routes.length - 1].route
      app.globalData[`${app.globalData.shopInfo.shopCode}_${page}_${this.data.datas.id}_thisPageIsPushed`] = true
      if (
        this.data.datas.componentData.columnNum > 0 &&
        this.data.datas.componentData.autoOff
      ) {
        clearTimeout(this.timeout);
        this.data.timeout = setTimeout(() => {
          this.setData({ domainShow: false })
        }, this.data.datas.componentData.columnNum * 1000);
      }
    },
    // 根据条件判断是否推送
    isPush() {
      let routes = getCurrentPages()
      let page = routes[routes.length - 1].route
      switch(this.data.datas.componentData.pushFrequency) {
        case '0':
          // 永久一次 推送
          let pushCount = wx.getStorageSync(`${app.globalData.shopInfo.shopCode}_${page}_${this.data.datas.id}_onlyPushOnceCount`);
          if(pushCount !='pushed') {
            wx.setStorageSync(`${app.globalData.shopInfo.shopCode}_${page}_${this.data.datas.id}_onlyPushOnceCount`, 'pushed');
            this.setData({ domainShow: true })
            this.autoOff()
            wx.removeStorageSync(`${app.globalData.shopInfo.shopCode}_${page}_${this.data.datas.id}_dayPushTimeInfo`) //清除按天推送的缓存，防止切换配置后出错
          }else {
            break;
          }
          break;
        case '1':
          // 每次进入 推送
          wx.removeStorageSync(`${app.globalData.shopInfo.shopCode}_${page}_${this.data.datas.id}_dayPushTimeInfo`) //清除按天推送的缓存，防止切换配置后出错
          wx.removeStorageSync(`${app.globalData.shopInfo.shopCode}_${page}_${this.data.datas.id}_onlyPushOnceCount`) //清除永久推送的缓存，防止切换配置后出错
          this.setData({ domainShow: true })
          this.autoOff()
          break;
        case '2':
          // 自定义
          if(this.data.datas.componentData.isDayOrWeek == '0') {
            // 按天推送
            this.timedDayPush()
            wx.removeStorageSync(`${app.globalData.shopInfo.shopCode}_${page}_${this.data.datas.id}_onlyPushOnceCount`) //清除永久推送的缓存，防止切换配置后出错
          }else if(this.data.datas.componentData.isDayOrWeek == '1') {
            // 按周推送
            this.timedWeekPush()
            wx.removeStorageSync(`${app.globalData.shopInfo.shopCode}_${page}_${this.data.datas.id}_dayPushTimeInfo`) //清除按天推送的缓存，防止切换配置后出错
            wx.removeStorageSync(`${app.globalData.shopInfo.shopCode}_${page}_${this.data.datas.id}_onlyPushOnceCount`) //清除永久推送的缓存，防止切换配置后出错
          }
          break;
      }
    },
    // 自定义定时推送，按天数
    timedDayPush() {
      let routes = getCurrentPages()
      let page = routes[routes.length - 1].route
      // 如果缓存中没有信息，或者缓存中应该弹窗的时间已经过去了，则弹窗，并算出下一次弹窗的时间。
      let nowTime = Date.now()
      let pushTimeInfo = wx.getStorageSync(`${app.globalData.shopInfo.shopCode}_${page}_${this.data.datas.id}_dayPushTimeInfo`);
      if(!pushTimeInfo ||  nowTime >= pushTimeInfo) {
        this.setData({ domainShow: true })
        this.autoOff()
        let nextPushTime = nowTime + Number(this.data.datas.componentData.pushDay) * 24 * 60 * 60 * 1000;
        wx.setStorageSync(`${app.globalData.shopInfo.shopCode}_${page}_${this.data.datas.id}_dayPushTimeInfo`,  JSON.stringify(nextPushTime))
      }
    },
    // 自定义定时推送，按周几
    timedWeekPush() {
      // 当天是周几
      let currentDayOfWeek = new Date().getDay().toString()
      // 如果当天在推送的周几中，则推送
      if(this.data.datas.componentData.pushWeek.includes(currentDayOfWeek)) {
        this.setData({ domainShow: true })
        this.autoOff()
      }
    },
    // getPopFlag() {
    //   let routes = getCurrentPages()
    //   let page = routes[routes.length - 1].route
    //   return wx.getStorageSync(`${app.globalData.shopInfo.shopCode}_popFlag_${page}_${this.data.datas.id}`)
    // },
    // setPopFlag(value) {
    //   app.globalData.setPopupStorage = 1;
    //   let routes = getCurrentPages()
    //   let page = routes[routes.length - 1].route
    //   wx.setStorageSync(`${app.globalData.shopInfo.shopCode}_popFlag_${page}_${this.data.datas.id}`, value)
    //   let popUpList =  wx.getStorageSync('popUpList') || [];
    //   popUpList.push(`${app.globalData.shopInfo.shopCode}_popFlag_${page}_${this.data.datas.id}`)
    //   wx.setStorageSync('popUpList', popUpList)
    //   console.log(app.globalData)
    // },
    backHandle(e){
      this.setData({
        domainShow : false
      })
      // if(this.data.datas.componentData.once){
      //   this.setPopFlag("true");
      // }
      app.trackCpn(e, this.data.datas.componentName, '关闭自动弹窗广告')
      clearTimeout(this.data.timeout);
    },
    onclickHandle(e) {
      app.trackCpn(e, this.data.datas.componentName, '点击自动弹窗广告')
      app.$themeToLink(this.data.datas.componentData.link);
    }
  }
})
