const app = getApp();
Component({
  // 启用插槽
  options: {
    multipleSlots: true
  },
  properties: {
    note: {
      type: Array
    },
    datas: {
      type: Object
    },
    padding: {
      type: Number
    },
    loading: {
      type: Boolean
    },
    finished: {
      type: Boolean
    }
  },
  onPageScroll(e) {
    console.log(e);
  },
  lifetimes: {
    created() {
      console.log("进入组件created");
      // this.initList();
    },
    attached() {
      console.log("进入组件attached");
      // this.initList();
    },
    ready() {
      console.log("进入组件ready");
      let _this = this;
      let { clientHeight } = this.data;
      wx.getSystemInfo({
        success: function(res) {
          let clientHeight = parseInt(res.windowHeight);
          _this.setData({ clientHeight });
        }
      });
    }
  },
  observers: {},
  data: {
    //列数
    waterfallImgCol: 2,
    //列高度数组
    waterfallDeviationHeight: [0, 0],
    contentList: [],
    inj: 0,
    clientHeight: 0, //窗口高度
    goodsNum: 0,
  },
  methods: {
    // 初始化数组
    initList(goodsList) {
      // 初始化容器
      let { contentList, waterfallDeviationHeight } = this.data;
      contentList[0] = [];
      contentList[1] = [];
      waterfallDeviationHeight = [0, 0];
      this.setData({ contentList, waterfallDeviationHeight });
      this.reLoadPro(goodsList);
    },
    async reLoadPro(goodsList) {
      console.log(goodsList,'----------------------75')
      // this.setHeight(this.data.goodsNum);
      this.setHeight1(this.data.goodsNum,goodsList);
      this.setData({
        goodsNum:
        goodsList.length > 0 ? goodsList.length + 1 : 0
      });
    },
    setHeight1(i,goodsList) {
      let itemList = goodsList.splice(i, goodsList.length);
      let { contentList } = this.data;
      itemList.forEach((item, index) => {
        if (index % 2 == 0) {
          contentList[0].push(item);
          console.log(item.productName, "--------位置--左");
        } else {
          contentList[1].push(item);
          console.log(item.productName, "--------位置--右");
        }
      });
      this.setData({ contentList });
    },
    setHeight(i) {
      let _this = this;
      let item = this.data.note[i];
      // console.log(i, "---------------i");
      // console.log(
      //   this.data.waterfallDeviationHeight,
      //   "-------waterfallDeviationHeight"
      // );
      let minIndex = this.filterMin();
      // console.log(minIndex, "---------------126");
      let contentList = this.data.contentList;
      contentList[minIndex].push(item);
      this.setData({ contentList });
      _this
        .createSelectorQuery()
        .select(`.item${minIndex}`)
        .boundingClientRect(function(res) {
          if (res) {
            res.height;
            console.log(res, "--------------res");
            let waterfallDeviationHeight = _this.data.waterfallDeviationHeight;
            waterfallDeviationHeight[minIndex] = res.height;
            _this.setData({ waterfallDeviationHeight });
            if (i >= _this.data.note.length - 1) {
              return;
            }
            i++;
            _this.setHeight(i);
          }
        })
        .exec();
      // const queryDom = wx.createSelectorQuery().in(this);
      // queryDom.select(`.item${minIndex}`).boundingClientRect();
      // queryDom.exec(res => {
      //   res[0].height;
      //   console.log(res[0], "--------------res");
      //   let waterfallDeviationHeight = _this.data.waterfallDeviationHeight;
      //   waterfallDeviationHeight[minIndex] = res[0].height;
      //   _this.setData({ waterfallDeviationHeight });
      //   if (i >= _this.data.note.length - 1) {
      //     return;
      //   }
      //   i++;
      //   _this.setHeight(i);
      // });
    },
    filterMin() {
      let val = Math.min.apply(null, this.data.waterfallDeviationHeight);
      // console.log(this.waterfallDeviationHeight,this.waterfallDeviationHeight.indexOf(val),'-------------------167')
      return this.data.waterfallDeviationHeight.indexOf(val);
    },
    imageLoad(ev) {
      let windowWidth = wx.getSystemInfoSync().windowWidth;
      let src = ev.currentTarget.dataset.src,
        width = ev.detail.width,
        height = ev.detail.height;
      let newWidth = parseInt(windowWidth * 0.49);
      let newHeight = parseInt(newWidth / (width / height));
      console.log(
        width,
        height,
        newWidth,
        newHeight,
        ev.target.dataset.id,
        "-----------------------219"
      );
    },
    getScroll(el) {
      console.log(el,'--------------161')
      let { finished } = this.properties;
      let _this = this;
      _this
        .createSelectorQuery()
        .select("#waterfallFlow")
        .boundingClientRect(function(res) {
          if (res) {
            let scrollTop = parseInt(el.scrollTop);
            let domHeight = parseInt(res.height);
            // 窗口高度+滚动高度等于 = 元素整体高度 -(预留一段距离加载) 触发父组件查询接口
            console.log(scrollTop,finished,'--------------finished')
            if (
              scrollTop + _this.data.clientHeight >= domHeight - 150 &&
              finished == false
            ) {
              _this.triggerEvent("onLoad");
            }
          }
        })
        .exec();
    }
  }
});
