import Vue from 'vue'
import App from './App'
import Store from './store/index'
import "../static/nicon/iconfont.css"
import goodsApi from "./api/goods"
import orderApi from "./api/order"
import promoteApi from "./api/promote";
import indexApi from './api/index'
import { createdUserJWTApi, getBcakUrlApi } from "./api/daoke";
import cartApi from './api/cart'
import classificationApi from "./api/classification";
import spokesmanApi from './api/spokesman'
import { DFSImg, concatUrl } from "@/utils/index";
//一些js工具类
import tool from "@/utils/tool";
var log = require('./utils/log')
import fenxiaoModel from "@/utils/fenxiaoModel";
import {
  $themeAddToCard,
  $themeArticleLike,
  getCoupon,
  themeMemberCardClick
} from "@/utils/mayi";
// import { $themeToLink, $themeAddToCard, $themeArticleLike } from "@/utils/mayi";
import "@/utils/themeModule";
// import { themeToLinkInit } from "@/utils/themeModule";
import shop from "./api/shop";
import spokesman from "@/api/spokesman";
import live from "@/api/live"

Vue.config.productionTip = false
App.mpType = 'app'
Vue.prototype.$store = Store

// 用户行为收集
console.log(Store.state,'---35')
let mpBehavior = require("../node_modules/mayi-analytics/dist/mayi.mpBehavior")
Vue.prototype.$mpBehavior = mpBehavior;

// 异常监控（行为收集）
let mpAnalytics = require("../node_modules/mayi-analytics/dist/mayi.mpAnalytics.js")
    .default;
mpAnalytics.init({
    url: process.env.NODE_ENV == 'production' ? "https://analytics.mayi888.com/ma.gif" : "https://analytics.mayi888.cn/ma.gif", //错误上报地址
    app: "mayi-mp-shop",//项目名称
    wx
});
Vue.prototype.$mpAnalytics = mpAnalytics;

const app = new Vue(App)
app.$mount()

// glob挂载到
let mpApp = getApp();
Vue.prototype.mpApp = mpApp
// 初始化
mpApp.fenxiaoModel = new fenxiaoModel({
  query_login_spoken:spokesman.query_login_spoken,
  becomepokesmanCustomer:spokesman.becomepokesmanCustomer,
  saveCustomerInviterInviteeRel:spokesman.saveCustomerInviterInviteeRel,
  getHomePageQuickAccess:spokesman.getHomePageQuickAccess,
  query_isEntry:spokesman.query_isEntry,
  getDistributorHomepage:spokesman.getDistributorHomepage,
  getDistributorHomepageGoodsList: spokesman.getDistributorHomepageGoodsList,
  getSpokesmanidByShare: spokesman.getSpokesmanidByShare,
  oneClickShopQuickCopy: spokesman.oneClickShopQuickCopy,
  apply_for_withdraw: spokesman.apply_for_withdraw
});
// 多主题方法初始化
global.themeToLinkInit({
  homeNative: 2,
  wx,
  getCoupon,
  themeMemberCardClick,
  requireFun: {
    createdUserJWT: createdUserJWTApi,
    getBcakUrl: getBcakUrlApi
  },
  extend:Store.state.extConfig
});
// 数据异步回调函数
// 商城
mpApp.shopCallBack = function () { }
// 多主题页面
mpApp.pageCallBack = function () { }
// 底部栏
mpApp.footerCallBack = function () { }
// webview变化
mpApp.webviewCallBack = function () { }
mpApp.shareInit = function () {};
mpApp.themeColorCallBack = function () {};

mpApp.indexBgCallBack = function(){ }

/**
 * 组件点击行为收集
 * @param {event} event 原生事件
 * @param {*} componentInfo 完整信息
 * @param {*} itemInfo 具体信息
 */
mpApp.trackCpn = (event, componentInfo, itemInfo) => {
  console.log('tzBehavior测试-----', event);
  let x = 0, y = 0;
  if (event) {
    if (event.x || event.detail.x) { x = event.x || event.detail.x }
    if (event.y || event.detail.y) { y = event.y || event.detail.y }
  }
  mpBehavior.trackEvent('cpn_click', {
    xAxis: x.toFixed(2) || 0, // x轴
    yAxis: y.toFixed(2) || 0, // y轴
    cpnInfo: JSON.stringify(componentInfo), // 完整信息
    itemInfo: JSON.stringify(itemInfo) || '' // 具体信息
  })
}

// 全局数据
mpApp.processEnv = process.env;
// 全局跳转 data为link对象
// mpApp.$themeToLink = $themeToLink
console.log('3555555', wx)
// 全局加入购物车
mpApp.$themeAddToCard = $themeAddToCard
// 文章点赞
mpApp.$themeArticleLike = $themeArticleLike
// api
mpApp.goodsApi = goodsApi;
mpApp.orderApi = orderApi;
mpApp.promoteApi = promoteApi;
mpApp.indexApi = indexApi;
mpApp.cartApi = cartApi;
mpApp.classificationApi = classificationApi;
mpApp.DFSImg = DFSImg;
mpApp.concatUrl = concatUrl;
mpApp.spokesmanApi = spokesmanApi

mpApp.getThemePage = getThemePage

mpApp.themeColor = {}
mpApp.log = log
mpApp.tool = tool

function getThemePage({mixid,shopid}) {
  shop
    .themePagesInfo({
      shopid,
      shopMixId: mixid,
      homePageFlag: true
    })
    .then((response) => {
      if (response.data.code == 200) {
        let data = response.data.data;
        if (Array.isArray(data) && data.length > 0) {
          console.log("90", data);

          mpApp.globalData.pageList = data;
          // app中异步数据回调 底部栏数据
          if (mpApp.pageCallBack) {
            mpApp.pageCallBack(data);
          }
        }
      }
    })
    .catch((err) => {});
}


// 当前用户 id
let userId
// 分销员 id
let spokesmanId
/**
 * 全局页面切换监听
 */
wx.onAppRoute(res => {
  // 获取当前页面信息
  let currentPage = getCurrentPages()
  // let fromPath = currentPage[currentPage.length - 1].__displayReporter.showReferpagepath
  new Promise((resolve) => {
    if (!spokesmanId) {
      // 获取当前分销员 id
      spokesman.getSpokesmanidByShare().then(res => {
        if (res.data.data.spokesmanId) { spokesmanId = res.data.data.spokesmanId }
      })
    }
    if (!userId) { // 防止多次调用
      // 获取当前用户 id
      live.getUserInfo().then(res => {
        if (res.data.code == 200) {
          wx.setStorageSync('loginUserInfo',res.data.data ? res.data.data : {})
          console.log(Store.state.loginUserInfo.mobilephone,'--------------mobilephone---1')
          userId = res.data.data ? res.data.data.userId : ''
        }

      })
    }
    userId && resolve()
  }).then(() => {
    mpBehavior.trackPageView({
      title: '',
      location: res.path,
      // path: fromPath.substring(0, fromPath.length - 5),
      path: res.path,
      sales: spokesmanId,
      userId: userId
    });
  })
})


// if (!mpApp.globalData.setPopupStorage){

//   let popUpList = wx.getStorageSync('popUpList') || []
//   let arr = []
//   popUpList.forEach(item=> {
//     arr.push(item)
//     wx.removeStorageSync(item)
//   })
//   arr.forEach(item => {
//     popUpList.splice(popUpList.indexOf(item),1)
//   })

//   wx.setStorageSync('popUpList', popUpList)

// }
