let app = getApp()
const { spokesmanApi, DFSImg, $themeToLink } = app;
const componentOptions = {
  // 组件选项
  options: {
    multipleSlots: true
  },
  behaviors: [],
  properties: {
    datas: {
      type: Object
    },
    scrollContent:{
      type:String,
      default:''
    },
  },
  // 组件数据
  data: {
    isPageHidden: false, // 页面是否处于隐藏状态
    query: {
      pageSize: 9999,
      pageNum: 1,
      productCategoryId: '',
      // distributorHomepageId: '1',//分销商主页ID ,
      goodsNameOrCode: '',//商品名或编码 ,
      hotRecommendFlag: 1,//是否热门推荐（0：否，1：是） ,
    },
    spokesmanInfo: {},
    parentSpokesmanHandImage: '11111111',
    lists: [],
    isShow: ''
  },
  // 数据监听器
  observers: {
    scrollContent(scrollContent) {
      console.log(scrollContent,555555555)
    }
  },
  // 组件生命周期
  lifetimes: {
    created() {},
    ready() {
      // let $scrollContent = document.querySelector(this.scrollContent);
      // $scrollContent.on('scroll', e => {
      //   if($scrollContent.scrollTop() > 24) {
      //     this.setData({ isShow: "is_show" });
      //   }else {
      //     this.setData({ isShow: "" });
      //   }
      // });
      // console.log(this.data.scrollContent,555555555)
      this.init()
    },
    moved() {},
    detached() {}
  },
  attached() {
  },
  definitionFilter() {},
  onPageScroll() {
    // console.log(e,444444444444);
  },
  // 页面生命周期
  pageLifetimes: {
    // 页面被展示
    show() {
      const { isPageHidden } = this.data;

      // show事件发生前，页面不是处于隐藏状态时
      if (!isPageHidden) {
        return;
      }

      // 重新执行定时器等操作
    },
    // 页面被隐藏
    hide() {
      this.setData({
        isPageHidden: true
      });

      // 清除定时器等操作
    },
    // 页面尺寸变化时
    resize() {}
  },
  // 组件方法
  methods: {
    init() {
      this.setData({ spokesmanInfo: app.fenxiaoModel.spokesmanInfo });
      this.spokesmanInfo = app.fenxiaoModel.spokesmanInfo;
      let parentSpokesmanHandImage = DFSImg(app.fenxiaoModel.spokesmanInfo.parentSpokesmanHandImage);
      this.setData({parentSpokesmanHandImage: parentSpokesmanHandImage});
      let query = {
        ...this.data.query,
        distributorHomepageId: this.spokesmanInfo.distributorHomepage.id,
      }
      console.log(query,555555777777)
      app.fenxiaoModel.getDistributorHomepageGoodsList(query).then(res=>{
        if(res) {
          let lists = [];
          let num = Math.ceil(res.length/3);
          for(let i = 0; i < num; i++) {
            lists.push(new Array());
          }
          res.forEach((ele,index)=>{
            ele.terminalProductGoods.imgUrl = DFSImg(ele.terminalProductGoods.imgUrl)
            ele.terminalProductGoods.discountPrice = (ele.terminalProductGoods.discountPrice-0).toFixed(2)
            ele.terminalProductGoods.salePrice = (ele.terminalProductGoods.salePrice-0).toFixed(2)
            ele.terminalProductGoods.discountPriceToatal = (ele.terminalProductGoods.salePrice-ele.terminalProductGoods.discountPrice).toFixed(2)
            let flag = Math.ceil((index+1)/3)
            lists[flag-1].push(ele)
          })
          // this.data.lists = lists;
          this.setData({ lists: lists });
        }
      })
    },
    toSpokesmanHomePage(e) {
      let linkVal = '/personalCenter/spokesmanCenter/mine/spokesmanHomePage?from=_goodsInfo'
      app.trackCpn(e, this.data.datas.componentName)
      $themeToLink({
        type: 1,
        link:linkVal,
      });
    },
    getScroll(el) {
      // console.log(el.scrollTop,555555555,this.data.isShow)
      if(el.scrollTop > 24) {
        if(this.data.isShow == 'is_show') {
          return
        }
        this.setData({ isShow: "is_show" });
      }else {
        if(this.data.isShow) {
          this.setData({ isShow: "" });
        }
      }
    },
    toGoodsInfo(event) {
      const item = event.currentTarget.dataset.item;
      let linkVal = `/goods/${item.terminalProductGoods.productId}`
      app.trackCpn(event, this.data.datas.componentName, item)
      $themeToLink({
        type: 1,
        link:linkVal,
      });
    }
  }
};

Component(componentOptions);


