const app = getApp();
const { log } = app;
const { goodsApi, DFSImg, $themeToLink } = app;
const componentOptions = {
  // 组件选项
  options: {
    multipleSlots: true
  },
  behaviors: [],
  properties: {
    datas: {
      type: Object
    },
    datasIndex:{
      type: Number,
      default: 0
    },
    goodsListIndex:{
      type: Number,
      default: 0
    },
    storageKey: {
      type: String,
      required: true // 必传
    }
  },
  // 组件数据
  data: {
    isPageHidden: false, // 页面是否处于隐藏状态
    titleIcon: "",
    classificationLoadPage: 1,
    classificationLoadNum: 10,
    queryProductInfoLoading: false,
    loading: false,
    scrollLoading: false, // 滚动加载优化后添加加载动画
    finished: false,
    goodsList:[],
    storageGoodsList:[],
    storageDatasList:[],
    pageSize:10,
    pageNum:1,
    pageGoodsList:[],
    loadingFlag:[],
  },
  // 数据监听器
  observers: {},
  // 组件生命周期
  lifetimes: {
    created() {},
    ready() {
      this.init();
    },
    moved() {},
    detached() {}
  },
  attached() {},
  definitionFilter() {},
  // 页面生命周期
  pageLifetimes: {
    // 页面被展示
    show() {
      const { isPageHidden } = this.data;

      // show事件发生前，页面不是处于隐藏状态时
      if (!isPageHidden) {
        return;
      }

      // 重新执行定时器等操作
    },
    // 页面被隐藏
    hide() {
      this.setData({
        isPageHidden: true
      });

      // 清除定时器等操作
    },
    // 页面尺寸变化时
    resize() {}
  },
  // 组件方法
  methods: {
    // setPageDatas(active){
      
    //   this.pageGoodsList = this.getStorageSync('pageGoodsList')
    //   console.log(this.pageGoodsList,active,'active');
    // },
    init() {
      let {
        goodsType,
        goodsSource,
        angleSignImg,
        titleIcon
      } = this.data.datas.componentData;
      angleSignImg = DFSImg(angleSignImg,150,150,1);
      if (titleIcon) {
        titleIcon = DFSImg(titleIcon);
      }
      this.setData({
        "data.datas.componentData.angleSignImg": angleSignImg,
        titleIcon
      });
      console.log(this.data.titleIcon, "----------------------------68");
      let ids = this.getStorageSync(`ids`);
      console.log(ids,'---ids--104'+this.data.storageKey)
      log.info(ids,'---ids--105')
      // 如果不是横向标签组件初始化缓存
      if (!this.data.storageKey.includes('transverseLabel')) {
        this.setStorageSync("pageGoodsList",[[]])
        this.setStorageSync("storageDatasList",[[]])
        this.setStorageSync("ids",[[]])
        this.setStorageSync("loadingFlag",[false])
        this.setStorageSync("pageNumList",[1])
      }
      if (goodsType == 0) {
        if (goodsSource == "classify") {
          //商品分类
          this.getProductList(1, 1);
        } else {
          //指定商品
          this.getProductList(2);
        }
      } else if (goodsType == 1) {
        if (goodsSource == "classify") {
          //商品分类
          this.getInterList(1);
        } else {
          //指定商品
          this.getInterList(2);
        }
      }
    },
    getProductList(code, type) {
      let { goodsList, goodsSort } = this.data.datas.componentData;
      let {
        classificationLoadPage,
        loading,
        finished,
        queryProductInfoLoading
      } = this.data;
      if (queryProductInfoLoading == true) {
        return;
      }
      this.setData({ queryProductInfoLoading: true });
      // type 1初始化 2滚动加载
      //分类查
      if (code == 1) {
        if (type == 1) {
          classificationLoadPage = 1;
        } else {
          classificationLoadPage++;
          loading = true;
        }
        this.setData({ classificationLoadPage, loading });
        let query = {
          categoryId: this.data.datas.componentData.categoryId,
          page: this.showRowNum() ? classificationLoadPage : 1,
          rows: this.showRowNum()
            ? this.data.classificationLoadNum
            : this.getItemNum(),
          sortColumn: goodsSort,
          sortType: goodsSort != 2 ? 1 : 0,
          whetherShowSoldOutGoods: this.data.datas.componentData
            .whetherShowSoldOutGoods,
          whetherQueryCollectCount: true,
          whetherUseVirtualSalesQty: true,
          whetherUseVirtualCollectCount: true,
          whetherFindDistributionCommission: this
            .whetherFindDistributionCommission,
          whetherFindRecommendedCardFlag: this.data.datas.componentData.vipPrice
            ? 1
            : 0,
          whetherShowGoodsDefaultTagFlag: this.data.datas.componentData
            .marketingTag
            ? 1
            : 0,
          whetherFindMultiShopFlag: 1
        }; // 当前页 // 一页多少条 //查询销售数量 //查询收藏数 //是否使用虚拟销售数量 //是否使用虚拟收藏人数 //是否查询商品佣金（0：不查询，1：展示，为空不查佣金） //是否查询会员价  1是  0否 //是否展示营销标签  1是  0否 //是否查询多商户   //商城使用
        goodsApi.queryProductInfo(query).then(res => {
          this.setData({ loading: false, queryProductInfoLoading: false });
          if (res.data.code == 200) {
            let goodsLists = res.data.data.list;
            if (type == 1) {
              goodsList = goodsLists;
            } else {
              goodsList = [...goodsList, ...goodsLists];
            }
            if (goodsLists && goodsLists.length < 10) {
              this.setData({ finished: true });
            }
            this.goodsListVal(goodsList, type);
          }
        });
      } else {
        // 商品产品详情
        let terminalProductIds = goodsList.map(element => {
          return element.terminalProductId;
        });
        if (terminalProductIds.length == 0) {
          return;
        }
        let briefQuery = {
          sortColumn: goodsSort,
          sortType: goodsSort != 2 ? 1 : 0,
          page: 1,
          rows: terminalProductIds.length,
          terminalProductIds: terminalProductIds,
          whetherShowSoldOutGoods: this.whetherShowSoldOutGoods
        }; // 当前页 // 一页多少条
        this.briefProduct(briefQuery);
      }
    },
    async briefProduct(query) {
      await goodsApi.queryBriefProductInfo(query).then(res => {
        if (res.data.code == 200) {
          let data = res.data.data.list;
          let ids = data.map(element => {
            let goodsList = this.render ? res.data.list : res.data.data.list;
            return element.terminalProductId;
          });

          let storageIds = this.getStorageSync('ids')
          console.log(this.data.goodsListIndex,storageIds,'--storageIds')
          storageIds[this.data.goodsListIndex] = ids
          this.setStorageSync('ids',storageIds)

          let storageDatasList = this.getStorageSync('storageDatasList')
          console.log(storageDatasList,'------228'+this.data.storageKey)
          storageDatasList[this.data.goodsListIndex] = this.data.datas.componentData
          this.setStorageSync('storageDatasList',storageDatasList)
          
          this.moreProduct(true);
        }
      });
    },

    async moreProduct(flag) {
      // 没有数据了就不再请求了，直接return
      if (this.data.pageGoodsList.length != 0  &&  this.data.pageGoodsList[this.data.datasIndex].length == this.getStorageSync('ids')[this.data.datasIndex].length) return
      this.setData({
        scrollLoading: true
      })
      let terminalProductIds = []
      console.log(pageNum,'page-----');
      let pageNumList = this.getStorageSync('pageNumList')
      let pageNum = null
      if (flag) {
        pageNum = pageNumList[this.data.goodsListIndex]
        terminalProductIds = this.getStorageSync('ids')[this.data.goodsListIndex].slice((pageNum - 1) * this.data.pageSize,pageNum * this.data.pageSize)
        pageNum += 1
        pageNumList[this.data.goodsListIndex] = pageNum
      }else{
        pageNum = pageNumList[this.data.datasIndex]
        terminalProductIds = this.getStorageSync('ids')[this.data.datasIndex].slice((pageNum - 1) * this.data.pageSize,pageNum * this.data.pageSize)
        pageNum += 1
        pageNumList[this.data.datasIndex] = pageNum
      }
      this.setStorageSync('pageNumList',pageNumList)
      let {
        vipPrice,
        marketingTag,
        whetherFindDistributionCommission,
        goodsList
      } = this.data.datas.componentData;
      let moreQuery = {
        terminalProductIds,
        whetherQueryCollectCount: true, //查询收藏数
        whetherUseVirtualSalesQty: true, //是否使用虚拟销售数量
        whetherUseVirtualCollectCount: true, //是否使用虚拟收藏人数
        whetherFindDistributionCommission: whetherFindDistributionCommission, //是否查询商品佣金（0：不查询，1：展示，为空不查佣金）
        whetherFindRecommendedCardFlag: vipPrice ? 1 : 0, //是否查询会员价  1是  0否
        whetherShowGoodsDefaultTagFlag: marketingTag ? 1 : 0, //是否展示营销标签  1是  0否
        whetherFindMultiShopFlag: 1 //是否查询多商户   //商城使用
      };
      goodsApi.queryMoreProductInfo(moreQuery).then(res => {
        if (res.data.code == 200) {
          goodsList = res.data.data;
          this.goodsListVal(goodsList, 1,flag);
        }
      });
    },
    goodsListVal(goodsList, type,flag) {
      console.log(goodsList, "------------goodsListVal");
      goodsList.forEach((item, index) => {
        item.marketingTag = item.defaultTags
          ? this.filtermark(
              item.defaultTags,
              this.data.datas.componentData.marketingTagList
            )
          : [];
        item.shopLogoUrl = DFSImg(item.shopLogoUrl);
        item.loadState = false
        item.coverImage = DFSImg(item.coverImage, 400, 400, 1);
        item.productImgUrl = DFSImg(item.productImgUrl, 400, 400, 1);
        item.minPrice = Number(item.minPrice).toFixed(2);
        item.qty = Number(item.qty);
        item.saleQty = item.saleQty ? Number(item.saleQty) : 1;
        item.totalCollectionCount = Number(item.totalCollectionCount) || 0;
        item.minPriceAfterRecommendedCardPriceTable = item.minPriceAfterRecommendedCardPriceTable
          ? Number(item.minPriceAfterRecommendedCardPriceTable)
          : "";
        item.minProductGoodsCommission = item.minProductGoodsCommission
          ? Number(item.minProductGoodsCommission).toFixed(2)
          : 0;
        item.minGoodsSuggestedRetailPrice = item.minGoodsSuggestedRetailPrice
          ? Number(item.minGoodsSuggestedRetailPrice).toFixed(2)
          : "";
        item.showVipPrice = this.showVipPrice(item, index);
        item.showVipTag = this.showVipTag(item, index);
        if (item.saleTime) {
          item.getSaleTime = 0;
          item.getSaleTime = this.getSaleTime(item.saleTime);
        }
      });
      var that = this

      let pageGoodsList = this.getStorageSync('pageGoodsList') || []
      if (flag) {
        pageGoodsList[that.data.goodsListIndex].push(...goodsList)
      }else{
        pageGoodsList[that.data.datasIndex].push(...goodsList)
        console.log(pageGoodsList[that.data.datasIndex],'--pageGoodsList[that.data.datasIndex]')
      }
      this.setStorageSync('pageGoodsList', pageGoodsList);


       // 获取是否要开启请求拦截
      let loadingFlag = this.getStorageSync('loadingFlag')
      loadingFlag[that.data.datasIndex] = false
      this.setStorageSync('loadingFlag', loadingFlag);
      that.setData({
        pageGoodsList,
      })
      this.setData({
        "datas.componentData.goodsList": goodsList,
        // goodsList
        loadingFlag,
        scrollLoading: false,
      },function () {
        // that.lazyloading();

        // 节点布局方案在组件嵌套层级过深测试无效
        // let goodsList = this.data.goodsList  // 获取原数据
        // goodsList.forEach((item,index)=>{
        //   wx.createIntersectionObserver().relativeToViewport({bottom: 20}).observe(`.goodsItemIndex${index}`, (ret) => {
        //     // if (ret.intersectionRatio > 0){
        //     //   group[i].show = true 
        //     // }
        //     // this.setData({ // 更新数据
        //     //   group
        //     // })
        //     console.log('1111');
        //   })
        // })
      })

      if (type == 1) {
        // 初始化
        if (this.selectComponent("#waterfallFlow")) {
          this.selectComponent("#waterfallFlow").initList(goodsList);
        }
      } else {
        // 滚动加载
        if (this.selectComponent("#waterfallFlow")) {
          this.selectComponent("#waterfallFlow").reLoadPro(goodsList);
        }
      }
    },

    // 触发图片加载
    lazyloading(){
      var that = this
      console.log(that.data.datasIndex,that.data.goodsListIndex,'datasIndex');
      console.log(that.data.pageGoodsList[that.data.datasIndex]);
      let storageDatasList = this.getStorageSync('storageDatasList') || []
      
      let { style } = storageDatasList[that.data.datasIndex];
      let type = ''
      if(style == 'list'){
        type = 'goods-item'
      }else{
        console.log("不是goods-item");
        return
      }
     
      let windowHeight =  wx.getSystemInfoSync().windowHeight
      let pageGoodsList =  this.getStorageSync('pageGoodsList') || []
      console.log(that.data.pageGoodsList,pageGoodsList,that.data.datasIndex,'pageGoodsList--loading');

      let loadingFlag =  this.getStorageSync('loadingFlag')
      // 如果所有的商品都加载完成直接return
      if (loadingFlag[that.data.datasIndex]) {
        console.log("如果所有的商品都加载完成直接return");
        return
      }

      let ids = this.getStorageSync('ids')[that.data.datasIndex]
      if (ids.length == that.data.pageGoodsList[that.data.datasIndex].length &&
        that.data.pageGoodsList[that.data.datasIndex][that.data.pageGoodsList[that.data.datasIndex].length -1].loadState == true
        ) {
        return
      }
      wx.createSelectorQuery().selectAll(`.goodsListItemIndex${that.data.datasIndex}>>>.${type}`).boundingClientRect(function(rects){
        for (let index = 0; index < rects.length; index++) {
          if (rects[index].top == 0 && rects[index].bottom == 0 && rects[index].left == 0 && rects[index].right == 0) {
            break
          }
          if (rects[index].top < windowHeight) {
            pageGoodsList[that.data.datasIndex][index].loadState = true
          }
        }

        that.setData({
          pageGoodsList,
        })
        // that.pageGoodsList = pageGoodsList
        console.log(rects,pageGoodsList[that.data.goodsListIndex], pageGoodsList[that.data.datasIndex],'fff');
        that.setStorageSync('pageGoodsList',pageGoodsList)



        // 如果当前分页倒数第一张加载完成直接 打开loadingFlag开关并加载下一页数据
        if (that.data.pageGoodsList[that.data.datasIndex][that.data.pageGoodsList[that.data.datasIndex].length -1].loadState == true) {
          loadingFlag[that.data.datasIndex] = true
          that.setData({
            loadingFlag,
          })
          that.setStorageSync('loadingFlag',loadingFlag)
          
          that.moreProduct(false)

          console.log('load--ok');
        }
      
      }).exec();

    },
    getSaleTime(val) {
      return new Date(val.replace(/-/g, "/")).getTime() - new Date().getTime();
    },
    getItemNum() {
      //数量
      if (
        this.data.datas.componentData.style === "list" &&
        this.data.datas.componentData["goodsSource"] != "assign"
      ) {
        //网格模式
        if (
          this.data.datas.componentData.rowNum *
            this.data.datas.componentData.columnNum >=
          this.data.datas.componentData.goodsList.length
        ) {
          return this.data.datas.componentData.goodsList.length;
        } else {
          return (
            this.data.datas.componentData.rowNum *
            this.data.datas.componentData.columnNum
          );
        }
      } else {
        return this.data.datas.componentData.goodsList.length;
      }
    },
    showRowNum() {
      return (
        this.data.datas.componentData.moreShow == false &&
        this.data.datas.componentData.style == "waterfall" &&
        this.data.datas.componentData.goodsSource == "classify"
      );
    },
    filtermark(newlist, marketingTagList) {
      let list = [];
      if (newlist.length <= 0) return;
      if (marketingTagList.length > 0) {
        marketingTagList.forEach((item, index) => {
          newlist.forEach((item1, index1) => {
            if (item1 == item.key) {
              list.push(item);
            }
          });
        });
      }
      return list;
    },
    showVipPrice(item, index) {
      // 索引 0 显示价格 1显示名称
      let showFlag = false;
      let vipPrice = item["minPriceAfterRecommendedCardPriceTable"];
      if (vipPrice && Number(vipPrice) < Number(item["minPrice"])) {
        showFlag = true;
      }
      return showFlag;
    },
    showVipTag(item, index) {
      // 索引 0 显示价格 1显示名称
      let showFlag = false;
      let vipPrice = item["minPriceAfterRecommendedCardPriceTable"];
      let showTag = item["recommendedCardMinPricePriceTableName"];
      if (vipPrice && showTag && Number(vipPrice) <= Number(item["minPrice"])) {
        showFlag = true;
      }
      return showFlag;
    },
    getScroll(el) {
      //! 如果不是当前tab页return不执行滚动加载
      if (this.data.datasIndex != this.data.goodsListIndex) return;
      // 是指定分类且不显示查看更多的瀑布流组件滚动加载
      let { goodsSource, moreShow, style } = this.data.datas.componentData;
      console.log('goodsSource, moreShow, style',goodsSource, moreShow, style);
      this.lazyloading()
      if (
        goodsSource == "classify" &&
        moreShow == false &&
        style == "waterfall"
      ) {
        this.selectComponent("#waterfallFlow").getScroll(el);
      }
    },
    // 分页加载
    onLoad() {
      console.log("---触发分页加载");
      this.getProductList(1, 2);
    },
    viewMore(e) {
      let {
        goodsType,
        style,
        categoryName,
        categoryId
      } = this.data.datas.componentData;
      let linkVal = "";
      if (goodsType != 1) {
        linkVal = `/goods/commodityMenu?categoryName=${categoryName}&categoryId=${categoryId}`;
      } else {
        linkVal = `/pointShop/productList?categoryName=${categoryName}&categoryId=${categoryId}`;
      }
      app.trackCpn(e, this.data.datas.componentName, 'ViewMore查看更多')
      $themeToLink({
        type: 1,
        link: linkVal
      });
    },
    setStorageSync(key, val) {
      console.log(`${this.data.storageKey}_${key}`,'-------------533')
      return wx.setStorageSync(`${this.data.storageKey}_${key}`,val)
    },
    getStorageSync(key) {
      console.log(`${this.data.storageKey}_${key}`,'-------------537')
      return wx.getStorageSync(`${this.data.storageKey}_${key}`)
    }
  }
};

Component(componentOptions);
