// static/nativeComponents/MerchantsList/index.js
let app = getApp()
const { indexApi } = app;
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    datas: {
      type: Object
    }
  },

  /**
   * 组件的初始数据
   */
  data: {
    showList : true,
    toLoad : true,
    query : {
      pageNum: 0,
      pageSize: 10,
      shopTagIds: [],
      mallFlag: 1,
    },
    WaterfallFlowList : [],
    skeletonLoading: true,
    loading: false,
    finished: false,
    clientHeight : 0,
    WaterfallFlowListL : [],
    WaterfallFlowListR : []
  },
  ready(){
    let _this = this;
    let { clientHeight } = this.data;
    wx.getSystemInfo({
      success: function (res) {
        let clientHeight = parseInt(res.windowHeight);
        _this.setData({ clientHeight });
      }
    });
    this.init()
  },

  /**
   * 组件的方法列表
   */
  methods: {
    init(){
      this.loadHandle(1);
    },
    loadHandle(val){
      if (this.data.toLoad == false) return;
      this.setData({
        toLoad: false
      })
      if(val == 1){
        this.setData({
          ['query.pageNum'] : 1,
          WaterfallFlowList : []
        })
      }else{
        this.setData({
          ['query.pageNum']: this.data.query.pageNum + 1
        })
      }
      this.setData({
        ['query.shopTagIds']: this.data.datas.componentData.selectMerchants == 0 ? [] : this.data.datas.componentData.selectLabelList,
      })
      indexApi.get_multi_merchant_by_tags(this.data.query).then(res => {
        this.setData({
          toLoad : true,
          skeletonLoading : false,
          loading : false
        })
        if(res.data.code == '200'){
          let list = res.data.data
          if(list == null || list.length == 0){
            if(this.query.pageNum == 1){
              this.setData({
                showList: false
              })
            }
          }else{
            list.forEach((item,index) => {
              item.logoUrl = item.logoUrl ? app.DFSImg(item.logoUrl,300,300,1) : app.DFSImg("");
            })
            if (val == 1){

              if (this.data.datas.componentData.layoutType == 0){

                this.setData({
                  WaterfallFlowListL: [],
                  WaterfallFlowListR: []
                })
                let  WaterfallFlowListL = []
                let WaterfallFlowListR = []
                list.forEach((item, index) => {
                  if (index % 2 == 0) {
                    WaterfallFlowListL.push(item)
                  } else {
                    WaterfallFlowListR.push(item)
                  }
                })
                this.setData({
                  'WaterfallFlowListL[0]': WaterfallFlowListL,
                  'WaterfallFlowListR[0]': WaterfallFlowListR
                })
              }else{
                  this.setData({
                    'WaterfallFlowList[0]': list
                  })
              }
            }else{
              if (this.data.datas.componentData.layoutType == 0) {
                let WaterfallFlowListL = []
                let WaterfallFlowListR = []

                  list.forEach((item,index) => {
                    if (index % 2 == 0) {
                      WaterfallFlowListL.push(item)
                    } else {
                      WaterfallFlowListR.push(item)
                    }
                  })
                this.setData({
                  ['WaterfallFlowListL[' + this.data.WaterfallFlowListL.length + ']']: WaterfallFlowListL,
                  ['WaterfallFlowListR[' + this.data.WaterfallFlowListR.length + ']']: WaterfallFlowListR
                })
              } else {
                this.setData({
                  ['WaterfallFlowList[' + this.data.WaterfallFlowList.length + ']']: list
                })
              }

            }
            if (this.data.WaterfallFlowList.length <= 0) {
              this.showList = false;
            }
          }
          if (list == null || list.length < 10) {
              this.setData({
                finished : true
              })
            } else {
              this.setData({
                finished: false
              })
            }

          console.log(this.data.WaterfallFlowList,'this.data.WaterfallFlowList')
        }else{
          this.setData({
            finished : true,
            showList : false
          })
        }

      })

    },
    getScroll(el) {
      let _this = this
      let query = wx.createSelectorQuery().in(this)
      let { windowHeight } = wx.getSystemInfoSync()
      query.select("#ItemModule0").boundingClientRect(function(res){
        if(res){
          // let scrollTop = parseInt(el.scrollTop);
          // let domHeight = parseInt(res.height);
          if (res.top < windowHeight && res.top + res.height > 0 && _this.data.finished == false) {

            _this.loadHandle(2);
          }
          // if (
          //   scrollTop + _this.data.clientHeight >= domHeight - 150 &&
          //   _this.data.finished == false
          // ) {
          //   console.log(scrollTop + _this.data.clientHeight, '44444444444')
          //   _this.loadHandle(2);
          // }
        }
      }).exec()

      query.select("#ItemModule1").boundingClientRect(function (res) {
        if (res) {
          // let scrollTop = parseInt(el.scrollTop);
          // let domHeight = parseInt(res.height);
          if (res.top < windowHeight && res.top + res.height > 0 && _this.data.finished == false) {
            _this.loadHandle(2);
          }
          // if (
          //   scrollTop + _this.data.clientHeight >= domHeight - 150 &&
          //   _this.data.finished == false
          // ) {
          //   console.log(scrollTop + _this.data.clientHeight, '44444444444')
          //   _this.loadHandle(2);
          // }
        }
      }).exec()

      // wx.createSelectorQuery().in(this).select("#ItemModule1").boundingClientRect(function(res){
      //   if (res) {

      //     let scrollTop = parseInt(el.scrollTop);
      //     let domHeight = parseInt(res.height);
      //     // 窗口高度+滚动高度等于 = 元素整体高度 -(预留一段距离加载) 触发父组件查询接口
      //     if (
      //       scrollTop + _this.data.clientHeight >= domHeight - 150 &&
      //       _this.data.finished == false
      //     ) {
      //       _this.loadHandle(2);
      //     }
      //   }
      // }).exec()
    },
    scrolltolower(){
      if(this.data.finished == false){
        this.loadHandle(2)
      }
    },
    itemClick(e){
      let item = e.currentTarget.dataset.item
      console.log(item)
      app.trackCpn(e, this.data.datas.componentName, item)
      app.$themeToLink({
        type: 1,
        link: `/merchantsDetail/${ item.boundOrgId }`
      })
    }
  }
})
