const app = getApp();
const { goodsApi, DFSImg, $themeToLink, $themeAddToCard } = app;
const componentOptions = {
  // 组件选项
  options: {
    multipleSlots: true
  },
  behaviors: [],
  properties: {
    datas: {
      type: Object
    },
    items: {
      type: Object
    },
    indexs: {
      type: Number
    }
  },
  // 组件数据
  data: {
    isPageHidden: false, // 页面是否处于隐藏状态
    timeData: {}
  },
  // 数据监听器
  observers: {},
  // 组件方法
  methods: {
    init() {},
    getSaleTime(val) {
      return new Date(val.replace(/-/g, "/")).getTime() - new Date().getTime();
    },
    showVipPrice(index) {
      // 索引 0 显示价格 1显示名称
      let showFlag = false;
      let vipPrice = this.items["minPriceAfterRecommendedCardPriceTable"];
      if (vipPrice && Number(vipPrice) < Number(this.items["minPrice"])) {
        showFlag = true;
      }
      console.log(showFlag, "------------760");
      return showFlag;
    },
    showVipTag(index) {
      // 索引 0 显示价格 1显示名称
      let showFlag = false;
      let vipPrice = this.items["minPriceAfterRecommendedCardPriceTable"];
      let showTag = this.items["recommendedCardMinPricePriceTableName"];
      if (
        vipPrice &&
        showTag &&
        Number(vipPrice) <= Number(this.items["minPrice"])
      ) {
        showFlag = true;
      }
      return showFlag;
    },
    onChange(e) {
      this.setData({ timeData: e.detail });
    },
    onclickProduct(e) {
      let { goodsType } = this.data.datas.componentData;
      let {
        productId,
        terminalProductId,
        terminalGoodsMixId
      } = this.data.items;
      let linkVal = "";
      if (goodsType == 0) {
        linkVal = `/goods/${productId}?terminalProductId=${terminalProductId}`;
      } else if (goodsType == 1) {
        linkVal = `/pointShop/goodsDetail?productId${productId}&terminalProductId=${terminalProductId}&terminalGoodsMixId=${terminalGoodsMixId}`;
      }
      app.trackCpn(e, this.data.datas.componentName)
      $themeToLink({
        type: 1,
        link: linkVal
      });
    },
    onclickBuynow(e) {
      let { btnType } = this.data.datas.componentData;
      let {
        minProductGoodsMixid,
        minProductGoodsId,
        minGoodsId
      } = this.data.items;
      let linkVal = "";
      if (btnType < 6) {
        // 加入购物车
        console.log("加入购物车");
        $themeAddToCard(this.data.items);
      } else {
        // 进入确认订单
        linkVal = `/order/orderConfirm?productGoodsMixId=${minProductGoodsMixid}&productGoodsId=${minProductGoodsId}&goodsId=${minGoodsId}&qty=1&goodsString=null&source=3`;
      }
      console.log(linkVal, "-------90");
      app.trackCpn(e, this.data.datas.componentName)
      $themeToLink({ type: 1, link: linkVal });
    },
    toMerchants(e) {
      let { orgId } = this.data.items;
      app.trackCpn(e, this.data.datas.componentName)
       $themeToLink({ type: 1, link: `/merchantsDetail/${orgId}` });

    },
  },
  // 组件生命周期
  lifetimes: {
    created() {},
    attached() {
      this.init();
    },
    ready() {},
    moved() {},
    detached() {}
  },
  definitionFilter() {},
  // 页面生命周期
  pageLifetimes: {
    // 页面被展示
    show() {
      const { isPageHidden } = this.data;

      // show事件发生前，页面不是处于隐藏状态时
      if (!isPageHidden) {
        return;
      }

      // 重新执行定时器等操作
    },
    // 页面被隐藏
    hide() {
      this.setData({
        isPageHidden: true
      });

      // 清除定时器等操作
    },
    // 页面尺寸变化时
    resize() {}
  }
};

Component(componentOptions)
