import TouchEvent from "./utils/touchEvent";
const componentOptions = {
  // 组件选项
  options: {
    multipleSlots: true
  },
  behaviors: [],
  properties: {
    datas: {
      type:Object
    },
    goodsList: {
      type:Array
    }
  },
  // 组件数据
  data: {
    isPageHidden: false, // 页面是否处于隐藏状态
    isLoading: false,
    swiperCurIndex: 0,
    slideClass: "",
    lockSwipe: false
  },
  // 数据监听器
  observers: {},
  // 组件生命周期
  lifetimes: {
    created() {
      new TouchEvent(this, "touchCard", {
        swipe: evt => {
          //在touch结束触发，evt.direction代表滑动的方向 ['Up','Right','Down','Left']
          if (evt.direction === "Left") this.next(evt);
          if (evt.direction === "Right") this.prev(evt);
        }
      });
    },
    attached() {}
  },

  // 组件方法
  methods: {
    next(e) {
      if (this.data.lockSwipe) return;
      this.data.lockSwipe = true;
      if (-this.data.swiperCurIndex >= this.data.goodsList.length - 1) {
        return (this.data.lockSwipe = false);
      }
      const index = e.currentTarget.dataset["index"];
      this.setData(
        { ["goodsList[" + index + "].slideClass"]: " ani-slide-up" },
        () => {
          this.setData({
            swiperCurIndex: --this.data.swiperCurIndex
          });
        }
      );
      setTimeout(() => {
        this.data.lockSwipe = false;
        this.setData({
          ["goodsList[" + index + "].slideClass"]: ""
        });
      }, 590);
    },
    prev(e) {
      const index = e.currentTarget.dataset["index"] - 1;
      if (this.data.lockSwipe || index < 0) return;
      this.data.lockSwipe = true;
      this.setData({
        ["goodsList[" + index + "].slideClass"]: " ani-slide-down",
        swiperCurIndex: ++this.data.swiperCurIndex
      });
      setTimeout(() => {
        this.data.lockSwipe = false;
        this.setData({
          ["goodsList[" + index + "].slideClass"]: ""
        });
      }, 590);
    }
  },
  definitionFilter() {},
  // 页面生命周期
  pageLifetimes: {
    // 页面被展示
    show() {
      const { isPageHidden } = this.data;

      // show事件发生前，页面不是处于隐藏状态时
      if (!isPageHidden) {
        return;
      }

      // 重新执行定时器等操作
    },
    // 页面被隐藏
    hide() {
      this.setData({
        isPageHidden: true
      });

      // 清除定时器等操作
    },
    // 页面尺寸变化时
    resize() {}
  }
};

Component(componentOptions);
