package com.mayi.demo;


import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;

import com.mayi.fastdevelop.base.BaseActivity;

import java.util.ArrayList;
import java.util.List;

public class MainActivity extends BaseActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        RecyclerView listView = findViewById(R.id.list);
        listView.setLayoutManager(new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false));
        final List<ItemBean> list = new ArrayList<>();
        list.add(new ItemBean("常用控件", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                gotoActivity(ViewActviity.class);
            }
        }));
        list.add(new ItemBean("二维码", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                gotoActivity(QRActivity.class);
            }
        }));
        listView.setAdapter(new RecyclerView.Adapter<MyViewHolder>() {
            @NonNull
            @Override
            public MyViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
                return new MyViewHolder(new Button(viewGroup.getContext()));
            }

            @Override
            public void onBindViewHolder(@NonNull MyViewHolder viewHolder, int i) {
                viewHolder.tv.setOnClickListener(list.get(i).getClickListener());
                viewHolder.tv.setText(list.get(i).getText());
            }

            @Override
            public int getItemCount() {
                return list.size();
            }
        });
    }

    class MyViewHolder extends RecyclerView.ViewHolder {

        Button tv;

        public MyViewHolder(@NonNull View itemView) {
            super(itemView);
            tv = (Button) itemView;
        }
    }

}
