package com.mayi.demo;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;

import com.mayi.fastdevelop.base.BaseActivity;
import com.mayi.fastdevelop.util.BitmapUtil;
import com.mayi.fastdevelop.util.QrUtil;

public class QRActivity extends BaseActivity {

    private ImageView img1, img2, img0;
    private Button bt, bt0;
    private EditText et, et0;
    private TextView tv;


    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.qr_layout);
        bt0 = findViewById(R.id.bt0);
        et0 = findViewById(R.id.et0);
        tv = findViewById(R.id.tv);
        img0 = findViewById(R.id.img0);
        img1 = findViewById(R.id.img1);
        img2 = findViewById(R.id.img2);
        bt = findViewById(R.id.bt);
        et = findViewById(R.id.et);
        bt0.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                img0.setImageBitmap(QrUtil.createBitmap(et0.getText().toString()));
             }
        });
        bt.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                img1.setImageBitmap(QrUtil.createBitmap(QRActivity.this, et.getText().toString(), R.mipmap.ic_launcher));

            }
        });
        img2.setBackgroundResource(R.mipmap.qr_icon);

        tv.setText("图片中二维码文字："+QrUtil.recogQRcode(BitmapUtil.getBitmap(this,R.mipmap.qr_icon)));
    }
}
