package com.mayi.demo;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;

import com.mayi.fastdevelop.base.BaseActivity;
import com.mayi.fastdevelop.util.ToastUtil;
import com.mayi.fastdevelop.view.CustomTitleBar;

public class TitleActivity extends BaseActivity{

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.title_activity_layout);
        CustomTitleBar titleBar1=findViewById(R.id.title1);
        titleBar1.setOnClickLeftViewListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                ToastUtil.show(v.getContext(),"点击返回");
            }
        });
        titleBar1.setTextCenter("标题1");

        CustomTitleBar titleBar2=findViewById(R.id.title2);
        titleBar2.setTextCenter("标题2");
        titleBar2.hideLeftView();
        titleBar2.setOnClickCenterTextListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                ToastUtil.show(v.getContext(),"点击标题");
            }
        });


        CustomTitleBar titleBar3=findViewById(R.id.title3);
        titleBar3.setTextCenter("标题3");
        titleBar3.showLeftCloseView();
        titleBar3.setTextRight("右边");
        titleBar3.setOnClickRightTextListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                ToastUtil.show(v.getContext(),"点击右边");
            }
        });
        titleBar3.hideLeftView();
        titleBar3.setOnClickLeftCloseListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                ToastUtil.show(v.getContext(),"点击关闭");
            }
        });

        CustomTitleBar titleBar4=findViewById(R.id.title4);
        titleBar4.setTextCenter("标题4");
        titleBar4.setImageRight(R.mipmap.icon_back);
        titleBar4.showRightView();
        titleBar4.setOnClickRightViewListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                ToastUtil.show(v.getContext(),"点击右边");
            }
        });

        CustomTitleBar titleBar5=findViewById(R.id.title5);
        titleBar5.setTextCenter("标题5");
        titleBar5.setTextCenterDrawableLeftRight(R.mipmap.ic_launcher,R.mipmap.ic_launcher_round);
    }
}
