package com.mayi.demo;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;

import com.mayi.fastdevelop.base.BaseActivity;
import com.mayi.fastdevelop.util.DialogUtils;
import com.mayi.fastdevelop.util.LogUtils;
import com.mayi.fastdevelop.util.ToastUtil;
import com.mayi.fastdevelop.view.wheel.ChangeAddressDialog;
import com.mayi.fastdevelop.view.wheel.ChangeBirthDialog;
import com.mayi.fastdevelop.view.wheel.ChangeDateDialog;
import com.mayi.fastdevelop.view.wheel.ChangeTimeDialog;

public class ViewActviity extends BaseActivity {


    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.test_layout);
        findViewById(R.id.b1).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                new ChangeAddressDialog(v.getContext(), new ChangeAddressDialog.OnAddressCListener() {
                    @Override
                    public void onClick(String province, String city) {
                        ToastUtil.show(ViewActviity.this, "province=" + province + " city=" + city);
                    }
                }).show();
            }
        });

        findViewById(R.id.b2).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                new ChangeBirthDialog(v.getContext(), new ChangeBirthDialog.OnBirthListener() {
                    @Override
                    public void onClick(String year, String month, String day) {
                        ToastUtil.show(ViewActviity.this, "year=" + year + " month=" + month + " day=" + day);
                    }
                }).show();
            }
        });
        findViewById(R.id.b3).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                new ChangeDateDialog(v.getContext(), new ChangeDateDialog.OnDateListener() {
                    @Override
                    public void onClick(String year, String month, String day) {
                        ToastUtil.show(ViewActviity.this, "year=" + year + " month=" + month + " day=" + day);
                    }
                }).show();
            }
        });
        findViewById(R.id.b4).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                new ChangeTimeDialog(v.getContext(), new ChangeTimeDialog.OnTimeListener() {
                    @Override
                    public void onClick(String year, String month, String day, String hour, String minute) {
                        ToastUtil.show(ViewActviity.this, "year=" + year + " month="
                                + month + " day=" + day + " hour=" + hour + " minute=" + minute);
                    }
                }).show();
            }
        });

        findViewById(R.id.b5).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                DialogUtils.showCommonDialog("标题", "左边", "右边", v.getContext(), new DialogUtils.DefaultDialogListener() {
                    @Override
                    public void onClickLeft() {
                        ToastUtil.show(ViewActviity.this,"点击左边");
                    }

                    @Override
                    public void onClickRight() {
                        ToastUtil.show(ViewActviity.this,"点击右边");
                    }
                });
            }
        });

        findViewById(R.id.b6).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                DialogUtils.showCommonDialog("标题",  v.getContext(), new DialogUtils.DefaultDialogListener() {
                    @Override
                    public void onClickLeft() {
                        ToastUtil.show(ViewActviity.this,"取消");
                    }

                    @Override
                    public void onClickRight() {
                        ToastUtil.show(ViewActviity.this,"确定");
                    }
                });
            }
        });

        findViewById(R.id.b7).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                DialogUtils.showTipsDialog("12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890",  v.getContext(), new DialogUtils.TipsDialogListener() {
                    @Override
                    public void onClickOK() {
                        ToastUtil.show(ViewActviity.this,"确定");
                    }
                });
            }
        });

        findViewById(R.id.b8).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                DialogUtils.showTipsDialog("1234567890yiersn",  v.getContext(), new DialogUtils.TipsDialogListener() {
                    @Override
                    public void onClickOK() {
                        ToastUtil.show(ViewActviity.this,"确定");
                    }
                });
            }
        });

        findViewById(R.id.b9).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                gotoActivity(TitleActivity.class);
            }
        });

        findViewById(R.id.b10).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                gotoActivity(BannerActivity.class);
            }
        });
        findViewById(R.id.b11).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                gotoActivity(LoadingPicturesActivity.class);
            }
        });

    }
}
