package com.mayi.fastdevelop.base;

import android.app.Dialog;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;

import com.mayi.fastdevelop.util.ToastUtil;
import com.mayi.fastdevelop.view.LoadingDialog;

public abstract class BaseActivity extends AppCompatActivity {

    private Dialog dialog;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

    }

    public void showLoadingDialog() {
        if (dialog == null) {
            dialog = LoadingDialog.init(this).show();
        } else {
            dialog.show();
        }
    }

    public void dismssLoadingDialog() {
        if (dialog != null) {
            dialog.dismiss();
        }
    }

    /**
     * 跳转页面并结束当前页面
     * @param activity
     */
    public void gotoActivityAndFinish(Class activity) {
        Intent intent = new Intent(this, activity);
        startActivity(intent);
        finish();
    }

    /**
     * 跳转页面
     * @param activity
     */
    public void gotoActivity(Class activity) {
        Intent intent = new Intent(this, activity);
        startActivity(intent);
    }

    /**
     * 跳转页面并结束当前页面
     * @param activity
     */
    public void gotoActivityAndFinish(Class activity,Bundle bundle) {
        Intent intent = new Intent(this, activity);
        intent.putExtras(bundle);
        startActivity(intent);
        finish();
    }

    /**
     * 跳转页面
     * @param activity
     */
    public void gotoActivity(Class activity,Bundle bundle) {
        Intent intent = new Intent(this, activity);
        intent.putExtras(bundle);
        startActivity(intent);
    }

    public void showToast(String msg){
        ToastUtil.show(this,msg);
    }

    @Override
    protected void onDestroy() {
        dismssLoadingDialog();
        super.onDestroy();
    }
}
