/*
 *  /**
 *   * Copyright &copy; 2017-2020  All rights reserved.
 *   * Licensed under the yen License, Version 1.0 (the "License");
 *
 */

package com.mayi.fastdevelop.view.wheel.views;

/**
 * Wheel changed listener interface.
 * <p>
 * The onChanged() method is called whenever current wheel positions is changed:
 * <li>New Wheel position is set
 * <li>Wheel view is scrolled
 */
public interface OnWheelChangedListener {
	/**
	 * Callback method to be invoked when current item changed
	 * 
	 * @param wheel
	 *            the wheel view whose state has changed
	 * @param oldValue
	 *            the old value of current item
	 * @param newValue
	 *            the new value of current item
	 */
	void onChanged(CustomWheelView wheel, int oldValue, int newValue);
}
