package com.mayi.demo;

import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;

import androidx.annotation.Nullable;

import com.mayi.fastdevelop.base.BaseCutPicturesActivity;
import com.mayi.fastdevelop.util.BitmapUtil;

public class CutPicturesActivity extends BaseCutPicturesActivity implements View.OnClickListener {

    private ImageView img;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_cutpictures);
        img = findViewById(R.id.img);
        findViewById(R.id.bt1).setOnClickListener(this);
        findViewById(R.id.bt2).setOnClickListener(this);
    }

    @Override
    protected void getBitmapPath(String imgPath) {
        img.setImageBitmap(BitmapUtil.loadBitmapFromFile(imgPath));
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.bt1:
                goCamera();
                break;
            case R.id.bt2:
                goPhotoAlbum();
                break;
        }
    }
}
