package com.mayi.demo;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.viewpager.widget.ViewPager;

import com.mayi.fastdevelop.base.BaseFragment;
import com.mayi.fastdevelop.base.BaseFragmentActivity;
import com.mayi.fastdevelop.comnon.AppCallback;

import java.util.ArrayList;
import java.util.List;

public class FragmentInteractiveActivity extends BaseFragmentActivity {

    private TextView tv;
    private ViewPager viewPager;
    private List<BaseFragment> list = new ArrayList<>();
    private Handler handler;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_fragment_interactive);
        handler = new Handler(Looper.getMainLooper());
        tv = findViewById(R.id.tv);
        viewPager = findViewById(R.id.viewpager);
        list.add(getFragment("0"));
        list.add(getFragment("1"));
        list.add(getFragment("2"));
        list.add(getFragment("3"));
        viewPagerLoadFragments(list, viewPager);
    }


    @Override
    public void handleInfo(final String data, final AppCallback<String> callback) {
        tv.setText(data);
        showToast(data);
        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                if (callback != null) {
                    callback.callBack(getClass().getName() + "：已处理数据-->" + data);
                }
            }
        }, 1000);
    }

    public BaseFragment getFragment(String tag) {
        MyFragment fragment = new MyFragment();
        Bundle bundle = new Bundle();
        bundle.putString("tag", tag);
        fragment.setArguments(bundle);
        return fragment;
    }
}
