package com.mayi.demo;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.mayi.fastdevelop.base.BaseFragment;
import com.mayi.fastdevelop.base.BaseFragmentActivity;
import com.mayi.fastdevelop.comnon.AppCallback;
import com.mayi.fastdevelop.view.OnMultiClickListener;

import java.util.ArrayList;
import java.util.List;

public class FragmentInteractiveActivity2 extends BaseFragmentActivity {

    private TextView tv;
    private List<BaseFragment> list = new ArrayList<>();
    private Handler handler;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_fragment_interactive_2);
        findViewById(R.id.b1).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                showFragment(0);
            }
        });
        findViewById(R.id.b2).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                showFragment(1);
            }
        });
        findViewById(R.id.b3).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                showFragment(21);
            }
        });
        handler = new Handler(Looper.getMainLooper());
        tv = findViewById(R.id.tv);
        list.add(getFragment("0"));
        list.add(getFragment("1"));
        list.add(getFragment("2"));
        addFragmentsAndShowFragment(list, R.id.layout);
    }

    @Override
    public void handleInfo(final String data, final AppCallback<String> callback) {
        tv.setText(data);
        showToast(data);
        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                if (callback != null) {
                    callback.callBack(getClass().getName() + "：已处理数据-->" + data);
                }
            }
        }, 1000);
    }

    public BaseFragment getFragment(String tag) {
        MyFragment fragment = new MyFragment();
        Bundle bundle = new Bundle();
        bundle.putString("tag", tag);
        fragment.setArguments(bundle);
        return fragment;
    }

}
