package com.mayi.demo;

import android.os.Bundle;
import android.view.View;

import androidx.annotation.Nullable;

import com.alibaba.fastjson.JSON;
import com.gc.call.CallConstant;
import com.gc.call.CallManage;
import com.gc.call.CallParticipationBean;
import com.gc.call.CallReturnBean;
import com.gc.call.CallReturnListener;
import com.mayi.fastdevelop.base.BaseActivity;
import com.mayi.fastdevelop.bean.UserInfo;
import com.mayi.fastdevelop.comnon.Constant;
import com.mayi.fastdevelop.okhttp.NetWorkBuilder;
import com.mayi.fastdevelop.okhttp.ResultCallback;
import com.mayi.fastdevelop.util.LogUtils;
import com.mayi.fastdevelop.view.OnMultiClickListener;

public class FunctionActivity extends BaseActivity {

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_function);
        findViewById(R.id.b1).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                gotoActivity(QRActivity.class);
            }
        });
        findViewById(R.id.b2).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                gotoActivity(PermissionActivity.class);
            }
        });
        findViewById(R.id.b3).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                gotoActivity(DownLoadAPKActivity.class);
            }
        });
        findViewById(R.id.b4).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                gotoActivity(FragmentInteractiveActivity.class);
            }
        });
        findViewById(R.id.b5).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                gotoActivity(FragmentInteractiveActivity2.class);
            }
        });
        findViewById(R.id.b6).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                new NetWorkBuilder().setUrl(
                        "https://backendrelease.kukahome.com:443/iretail/common/getAuthDataDealerList")
                        .setMethod(Constant.NETWORK_METHOD_GET)
                        .setCallback(new ResultCallback<String>() {
                            @Override
                            public void onFail(String msg) {
                                LogUtils.i(msg);
                                showToast(msg);
                            }

                            @Override
                            public void onSuccess(String o) {
                                LogUtils.i(o);
                                showToast(o.toString());
                            }
                        }).execute();
            }
        });

        findViewById(R.id.b7).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                new NetWorkBuilder().setUrl("https://customer.kujiatech.com/api/thirdPartyService/notify/getNotify")
                        .addParam("1", "22")
                        .setCallback(new ResultCallback<UserInfo>() {
                            @Override
                            public void onFail(String msg) {
                                showToast(msg);
                            }

                            @Override
                            public void onSuccess(UserInfo o) {
                                showToast(o.toString());
                            }
                        }).execute();
            }
        });
        findViewById(R.id.b8).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                CallParticipationBean bean = new CallParticipationBean("map_location");
                bean.setTag("map_location");
                bean.setContext(FunctionActivity.this);
                bean.setLooper(CallConstant.LOOPER_NO_MAIN);
                bean.setCallReturnListener(new CallReturnListener() {
                    @Override
                    public void onReturn(CallReturnBean bean) {
                        showToast(JSON.toJSONString(bean));
                    }
                });
                CallManage.getInstance().handleTarget(bean);
            }
        });
        findViewById(R.id.b9).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                gotoActivity(PlayerActivity.class);
            }
        });
    }

}
