package com.mayi.demo;

import android.os.Bundle;
import android.os.Handler;

import com.mayi.fastdevelop.base.BaseActivity;
import com.mayi.fastdevelop.view.lazyLoading.ListLazyLoadingView;

import java.util.ArrayList;
import java.util.List;

public class ListLazyLoadingActivity extends BaseActivity implements ListLazyLoadingView.ListLazyLoadingViewListener {

    private ListLazyLoadingView view;
    private MyListLazyLoadingAdapter adapter;
    private Handler handler;
    private List<Integer> list = new ArrayList<>();
    private int addItemCount, maxItemCount;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.layout_1);
        addItemCount = getIntent().getIntExtra("addItemCount", 10);
        maxItemCount = getIntent().getIntExtra("maxItemCount", 50);
        for (int i = 0; i < 20; i++) {
            list.add(0);
        }
        handler = new Handler();
        view = findViewById(R.id.view);
        view.setListLazyLoadingViewListener(this);
        adapter = new MyListLazyLoadingAdapter(list);
        view.setListLazyLoadingAdapter(adapter);
    }

    @Override
    public void onLoadMore() {
        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                for (int i = 0; i < addItemCount; i++) {
                    list.add(0);
                }
                if (list.size() >= maxItemCount) {
                    view.setLoadingAll(true);
                }
                view.finishLoadMore();
                adapter.notifyDataSetChanged();
            }
        }, 1000);
    }
}
