package com.mayi.demo;


import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.mayi.fastdevelop.base.BaseActivity;
import com.mayi.fastdevelop.util.DrawableUtils;

import java.util.ArrayList;
import java.util.List;

public class MainActivity extends BaseActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        RecyclerView listView = findViewById(R.id.list);
        listView.setLayoutManager(new LinearLayoutManager(this, RecyclerView.VERTICAL, false));
        final List<ItemBean> list = new ArrayList<>();
        list.add(new ItemBean("常用控件", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                gotoActivity(ViewActviity.class);
            }
        }));
        list.add(new ItemBean("常用功能", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                gotoActivity(FunctionActivity.class);
            }
        }));
        list.add(new ItemBean("常用页面", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                gotoActivity(PageActivity.class);
            }
        }));
        list.add(new ItemBean("图片裁剪", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                gotoActivity(CutPicturesActivity.class);
            }
        }));

        listView.setAdapter(new RecyclerView.Adapter<MyViewHolder>() {
            @NonNull
            @Override
            public MyViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
                return new MyViewHolder(new Button(viewGroup.getContext()));
            }

            @Override
            public void onBindViewHolder(@NonNull MyViewHolder viewHolder, int i) {
                viewHolder.tv.setOnClickListener(list.get(i).getClickListener());
                viewHolder.tv.setText(list.get(i).getText());
                DrawableUtils.setStatePressedDrawable(viewHolder.tv, "#555555", "#F00000", "#999999");
            }

            @Override
            public int getItemCount() {
                return list.size();
            }
        });
    }

    class MyViewHolder extends RecyclerView.ViewHolder {

        Button tv;

        public MyViewHolder(@NonNull View itemView) {
            super(itemView);
            tv = (Button) itemView;
        }
    }


}
